/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.template;

import java.io.IOException;
import java.io.Writer;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.Operand;
import org.ujac.util.template.BaseTemplateInterpreter;
import org.ujac.util.template.TemplateContext;
import org.ujac.util.template.TemplateToken;
import org.ujac.util.template.TemplateTokenContainer;

public class StaticToken
extends TemplateToken {
    private static final long serialVersionUID = 3257853190148798776L;
    private String text = null;

    public StaticToken(BaseTemplateInterpreter interpreter, char[] source, int position, int length) {
        super(source, position, length);
        this.interpreter = interpreter;
        this.text = new String(source, position, length);
    }

    public void setArgument(Operand argument, int idx) {
    }

    public void execute(Writer writer, TemplateContext ctx) throws ExpressionException, IOException {
        writer.write(this.text);
    }

    public String toString() {
        return this.getIndention() + this.text + "\n";
    }

    protected TemplateToken cloneToken(BaseTemplateInterpreter interpreter, TemplateTokenContainer parent) {
        StaticToken clone = (StaticToken)this.clone();
        clone.interpreter = interpreter;
        clone.parent = parent;
        return clone;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to clone template token: " + ex.getMessage(), ex);
        }
    }
}

