/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.template;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.Operand;
import org.ujac.util.template.BaseTemplateInterpreter;
import org.ujac.util.template.StatementException;
import org.ujac.util.template.TemplateContext;
import org.ujac.util.template.TemplateException;
import org.ujac.util.template.TemplateTokenContainer;
import org.ujac.util.template.TokenAncestor;

public abstract class TemplateToken
implements Serializable,
Cloneable {
    protected BaseTemplateInterpreter interpreter = null;
    protected TemplateTokenContainer parent = null;
    private int level = 0;
    protected char[] source = null;
    protected int position;
    private int length;
    protected int nextLegalAncestor = 0;

    public TemplateToken() {
    }

    public TemplateToken(char[] source, int position, int length) {
        this.source = source;
        this.position = position;
        this.length = length;
    }

    public String getTokenName() {
        return null;
    }

    public TokenAncestor[] getAncestorRules() {
        return null;
    }

    public boolean checkContainer(TemplateTokenContainer container) {
        return true;
    }

    public TemplateTokenContainer getParent() {
        return this.parent;
    }

    public void setParent(TemplateTokenContainer parent) {
        this.parent = parent;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean isBodyToken() {
        return false;
    }

    public boolean isLegalAncestor(String token) {
        TokenAncestor[] ancestorRules = this.getAncestorRules();
        if (ancestorRules == null) {
            return false;
        }
        for (int i = this.nextLegalAncestor; i < ancestorRules.length; ++i) {
            TokenAncestor ancestor = ancestorRules[i];
            if (!ancestor.getToken().equals(token)) continue;
            return true;
        }
        return false;
    }

    public boolean isLegalAncestor(TemplateToken token) {
        return this.isLegalAncestor(token.getTokenName());
    }

    public int parseArguments() throws ExpressionException {
        String tokenName = this.getTokenName();
        if (tokenName == null) {
            return this.position;
        }
        int curPos = this.position + tokenName.length() + 2;
        return this.parseArguments(curPos);
    }

    protected int parseArguments(int offset) throws ExpressionException {
        int curPos;
        int argIdx = 0;
        char[] source = this.source;
        int endPos = source.length - 1;
        int parenthesisLevel = 0;
        for (int i = offset; i <= endPos; ++i) {
            char c = source[i];
            if (c == '(') {
                ++parenthesisLevel;
                continue;
            }
            if (c != ')' || --parenthesisLevel != 0) continue;
            endPos = i - 1;
            break;
        }
        if (parenthesisLevel != 0) {
            throw new StatementException("Syntax error at position " + offset + ": unbalanced parethesis.");
        }
        for (int i = curPos = offset + 1; i <= endPos; ++i) {
            char c = source[i];
            if (c == ',' || Character.isWhitespace(c)) continue;
            Operand operand = this.parseConstant(i, endPos, argIdx);
            ++argIdx;
            i += operand.getRelativePosition() + operand.getLength();
        }
        return endPos + 1;
    }

    private Operand parseConstant(int argStart, int argEnd, int argIdx) throws ExpressionException {
        Operand operand = this.interpreter.exi.parseOperand(this.source, argStart, argEnd, true);
        this.setArgument(operand, argIdx);
        return operand;
    }

    public void initialize(BaseTemplateInterpreter interpreter, char[] source, int position, int length) throws TemplateException {
        this.interpreter = interpreter;
        this.source = source;
        this.position = position;
        this.length = length;
    }

    public char[] getSource() {
        return this.source;
    }

    public int getLength() {
        return this.length;
    }

    protected void setLength(int length) {
        this.length = length;
    }

    public int getPosition() {
        return this.position;
    }

    public int getEndPosition() {
        return this.position + this.length;
    }

    public abstract void execute(Writer var1, TemplateContext var2) throws TemplateException, IOException;

    public abstract void setArgument(Operand var1, int var2) throws StatementException;

    protected String getIndention() {
        if (this.level == 0) {
            return "";
        }
        StringBuffer ib = new StringBuffer(this.level);
        for (int i = 0; i < this.level; ++i) {
            ib.append('\t');
        }
        return ib.toString();
    }

    protected String getArgumentsAsString() {
        return "";
    }

    protected abstract TemplateToken cloneToken(BaseTemplateInterpreter var1, TemplateTokenContainer var2);
}

