/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ujac.util.CollectionUtils;
import org.ujac.util.template.TemplateToken;

public abstract class TemplateTokenContainer
extends TemplateToken {
    protected Map procedureRegistry = null;
    private List tokens = new ArrayList();
    private int bodyStart = -1;
    private int bodyEnd = -1;
    private boolean closed = false;

    public boolean isBodyToken() {
        return true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close(int bodyEnd, int statementEnd) {
        this.closed = true;
        this.bodyEnd = bodyEnd;
        this.setLength(statementEnd - this.position + 1);
    }

    public final int getTokenCount() {
        return this.tokens.size();
    }

    public final TemplateToken getToken(int idx) {
        return (TemplateToken)this.tokens.get(idx);
    }

    public final void addToken(TemplateToken token) {
        token.setParent(this);
        token.setLevel(this.getLevel() + 1);
        if (token.isBodyToken()) {
            TemplateTokenContainer childContainer = (TemplateTokenContainer)token;
            childContainer.setProcedureRegistry(this.procedureRegistry);
        }
        if (token.checkContainer(this)) {
            this.tokens.add(token);
        }
    }

    public final void clearTokens() {
        this.tokens.clear();
    }

    public int getBodyStart() {
        return this.bodyStart;
    }

    public void setBodyStart(int bodyStart) {
        this.bodyStart = bodyStart;
    }

    public int getBodyEnd() {
        return this.bodyEnd;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        int numTokens = this.getTokenCount();
        for (int i = 0; i < numTokens; ++i) {
            TemplateToken t = this.getToken(i);
            b.append(t);
        }
        return b.toString();
    }

    public Map getProcedureRegistry() {
        return this.procedureRegistry;
    }

    public void setProcedureRegistry(Map registry) {
        this.procedureRegistry = registry;
    }

    protected void cloneChildTokens(Map procedureRegistry, TemplateTokenContainer parent) {
        this.procedureRegistry = procedureRegistry;
        int numChilds = CollectionUtils.getSize(this.tokens);
        for (int i = 0; i < numChilds; ++i) {
            TemplateToken clonedToken = ((TemplateToken)this.tokens.get(i)).cloneToken(this.interpreter, parent);
            clonedToken.setLevel(this.getLevel() + 1);
            this.tokens.set(i, clonedToken);
            if (!clonedToken.isBodyToken()) continue;
            TemplateTokenContainer childContainer = (TemplateTokenContainer)clonedToken;
            childContainer.setProcedureRegistry(this.procedureRegistry);
        }
    }
}

