/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;

public class BigDecimalFormat
extends DecimalFormat {
    private static final long serialVersionUID = 3690478034742620467L;
    private int roundingMode = 4;

    public BigDecimalFormat() {
    }

    public BigDecimalFormat(String pattern) {
        super(pattern);
    }

    public BigDecimalFormat(String pattern, int roundingMode) {
        super(pattern);
        this.roundingMode = roundingMode;
    }

    public BigDecimalFormat(String pattern, DecimalFormatSymbols symbols) {
        super(pattern, symbols);
    }

    public BigDecimalFormat(String pattern, DecimalFormatSymbols symbols, int roundingMode) {
        super(pattern, symbols);
        this.roundingMode = roundingMode;
    }

    public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
        int maxFractionDigits = this.getMaximumFractionDigits();
        try {
            BigDecimal bd = new BigDecimal(number).setScale(maxFractionDigits, this.roundingMode);
            return super.format(bd.doubleValue(), result, fieldPosition);
        }
        catch (NumberFormatException ex) {
            return super.format(number, result, fieldPosition);
        }
    }

    public int getRoundingModeId() {
        return this.roundingMode;
    }

    public void setRoundingModeId(int roundingMode) {
        this.roundingMode = roundingMode;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }
}

