/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.types;

import java.text.ParseException;
import java.util.Date;
import org.ujac.util.TypeConverterException;
import org.ujac.util.text.FormatHelper;
import org.ujac.util.types.DataType;

public class DateType
implements DataType {
    public int getTypeId() {
        return 8;
    }

    public Object convertObject(Object value, FormatHelper formatHelper) throws TypeConverterException {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return value;
        }
        String strVal = value.toString();
        try {
            return formatHelper.getIsoDateFormat().parse(strVal);
        }
        catch (ParseException ex) {
            throw new TypeConverterException("Failed to parse Date value out of given value '" + strVal + "'.", ex);
        }
    }

    public String formatValue(Object value, FormatHelper formatHelper) throws TypeConverterException {
        return formatHelper.getIsoDateFormat().format((Date)this.convertObject(value, formatHelper));
    }
}

