/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.types;

import org.ujac.util.BeanUtils;
import org.ujac.util.TypeConverterException;
import org.ujac.util.text.FormatHelper;
import org.ujac.util.types.DataType;

public class DoubleType
implements DataType {
    public int getTypeId() {
        return 6;
    }

    public Object convertObject(Object value, FormatHelper formatHelper) throws TypeConverterException {
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return value;
        }
        if (value instanceof Number) {
            return new Double(((Number)value).doubleValue());
        }
        String strVal = value.toString();
        try {
            double val = Double.parseDouble(strVal);
            return new Double(val);
        }
        catch (NumberFormatException ex) {
            throw new TypeConverterException("Failed to parse double value out of given value '" + strVal + "'.", ex);
        }
    }

    public String formatValue(Object value, FormatHelper formatHelper) throws TypeConverterException {
        return BeanUtils.toString(this.convertObject(value, formatHelper));
    }
}

