/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.ujac.util.BeanException;
import org.ujac.util.BeanUtils;
import org.ujac.util.DefaultTypeConverter;
import org.ujac.util.TypeConverter;
import org.ujac.util.TypeConverterException;
import org.ujac.util.xml.AttributeDefinition;
import org.ujac.util.xml.BaseObjectSerializer;
import org.ujac.util.xml.ComplexTypeDefinition;
import org.ujac.util.xml.ElementDefinition;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DynamicObjectSerializer
extends BaseObjectSerializer {
    private ElementDefinition rootElement = null;
    private Map tagDefinitions = new HashMap();
    private Map classDefinitions = new HashMap();
    private TypeConverter typeConverter = null;

    public DynamicObjectSerializer() {
        this(null, new DefaultTypeConverter());
    }

    public DynamicObjectSerializer(String encoding) {
        this(encoding, new DefaultTypeConverter());
    }

    public DynamicObjectSerializer(String encoding, TypeConverter typeConverter) {
        super(encoding);
        this.typeConverter = typeConverter;
        this.registerComplexTypes();
    }

    public ElementDefinition getRootElement() {
        return this.rootElement;
    }

    public void setRootElement(ElementDefinition rootElement) {
        this.rootElement = rootElement;
    }

    protected void registerComplexTypes() {
        this.setComplexType(new ComplexTypeDefinition(List.class){

            public Object createInstance() {
                return new ArrayList();
            }

            protected void analyzeClass() {
            }

            public Iterator elementIterator(Object instance) {
                return ((Collection)instance).iterator();
            }

            public boolean hasBody() {
                return true;
            }
        });
        this.setComplexType(new ComplexTypeDefinition(Set.class){

            public Object createInstance() {
                return new HashSet();
            }

            protected void analyzeClass() {
            }

            public Iterator elementIterator(Object instance) {
                return ((Collection)instance).iterator();
            }

            public boolean hasBody() {
                return true;
            }
        });
    }

    public void setComplexType(ComplexTypeDefinition clazz) {
        this.tagDefinitions.put(clazz.getName(), clazz);
        this.classDefinitions.put(clazz.getType(), clazz);
    }

    public ComplexTypeDefinition getComplexType(String name) {
        return (ComplexTypeDefinition)this.tagDefinitions.get(name);
    }

    public ComplexTypeDefinition getComplexType(Class clazz) {
        if (clazz == null) {
            return null;
        }
        ComplexTypeDefinition ct = (ComplexTypeDefinition)this.classDefinitions.get(clazz);
        if (ct != null) {
            return ct;
        }
        Iterator iterElements = this.classDefinitions.entrySet().iterator();
        while (iterElements.hasNext()) {
            Map.Entry cdElem = iterElements.next();
            Class elemClazz = (Class)cdElem.getKey();
            if (!elemClazz.isAssignableFrom(clazz)) continue;
            return (ComplexTypeDefinition)cdElem.getValue();
        }
        return null;
    }

    public void write(PrintWriter writer, Object obj) throws IOException {
        super.write(writer, obj);
        this.writeObject(writer, null, obj, 0);
    }

    public void writeObject(PrintWriter writer, ElementDefinition elementDefinition, Object obj, int level) throws IOException {
        if (obj == null) {
            return;
        }
        Object[] getterArgs = new Object[]{};
        Class<?> clazz = obj.getClass();
        ComplexTypeDefinition typeDef = this.getComplexType(clazz);
        if (typeDef == null) {
            throw new IOException("Unable to write element '" + elementDefinition.getName() + "' of unregistered class '" + clazz.getName() + "!");
        }
        String tagName = typeDef.getName();
        if (level == 0 && this.rootElement != null) {
            tagName = this.rootElement.getName();
        }
        if (elementDefinition != null) {
            tagName = elementDefinition.getName();
        }
        this.indent(writer, level);
        writer.print("<");
        writer.print(tagName);
        List attributes = typeDef.getAttributes();
        int numAttributes = attributes.size();
        for (int i = 0; i < numAttributes; ++i) {
            AttributeDefinition attr = (AttributeDefinition)attributes.get(i);
            try {
                Method getter = attr.getGetter();
                if (getter == null) continue;
                String value = this.typeConverter.formatValue(attr.getType(), getter.invoke(obj, getterArgs));
                this.writeAttribute(writer, attr.getName(), value);
                continue;
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (TypeConverterException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
            }
        }
        if (!typeDef.hasBody() && level > 0) {
            writer.println("/>");
            return;
        }
        writer.println(">");
        List elementDefinitions = typeDef.getElementDefinitions();
        int numElementDefinitions = elementDefinitions.size();
        for (int i = 0; i < numElementDefinitions; ++i) {
            ElementDefinition elemDef = (ElementDefinition)elementDefinitions.get(i);
            try {
                Object elem = elemDef.getGetter().invoke(obj, BeanUtils.GETTER_ARGS);
                if (elem == null) continue;
                if (elem instanceof List) {
                    this.indent(writer, level + 1);
                    this.writeOpenTag(writer, elemDef.getName(), false, true);
                    List elemList = (List)elem;
                    int numElems = elemList.size();
                    for (int j = 0; j < numElems; ++j) {
                        this.writeObject(writer, null, elemList.get(j), level + 2);
                    }
                    this.indent(writer, level + 1);
                    this.writeCloseTag(writer, elemDef.getName(), true);
                    continue;
                }
                if (elem instanceof Collection) {
                    this.indent(writer, level + 1);
                    this.writeOpenTag(writer, elemDef.getName(), false, true);
                    Collection elems = (Collection)elem;
                    Iterator iterElems = elems.iterator();
                    while (iterElems.hasNext()) {
                        this.writeObject(writer, null, iterElems.next(), level + 2);
                    }
                    this.indent(writer, level + 1);
                    this.writeCloseTag(writer, elemDef.getName(), true);
                    continue;
                }
                this.writeObject(writer, elemDef, elem, level + 1);
                continue;
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        Iterator elementIterator = typeDef.elementIterator(obj);
        if (elementIterator != null) {
            while (elementIterator.hasNext()) {
                this.writeObject(writer, null, elementIterator.next(), level + 1);
            }
        }
        this.indent(writer, level);
        this.writeCloseTag(writer, tagName, true);
    }

    public void startElement(BaseObjectSerializer.StackElement localElement, BaseObjectSerializer.StackElement parentElement, Object root) throws SAXException {
        Class tagClazz;
        String localName = localElement.getName();
        Class localType = null;
        ComplexTypeDefinition tagDef = null;
        if (localElement.getLevel() == 0 && this.rootElement != null && BeanUtils.equals(this.rootElement.getName(), localName)) {
            localType = this.rootElement.getType();
            tagDef = this.getComplexType(localType);
            localElement.setTypeDefinition(tagDef);
        } else {
            try {
                if (parentElement != null && parentElement.getData() != null) {
                    localType = BeanUtils.getPropertyType(parentElement.getData().getClass(), localName, true);
                    tagDef = this.getComplexType(localType);
                    localElement.setTypeDefinition(tagDef);
                }
            }
            catch (BeanException ex) {
                // empty catch block
            }
        }
        if (tagDef == null) {
            tagDef = this.getComplexType(localName);
            localType = tagDef.getType();
            localElement.setTypeDefinition(tagDef);
        }
        if ((tagClazz = tagDef.getType()) == null) {
            throw new SAXException("Detected unsupported tag name '" + localName + "'");
        }
        Object instance = null;
        try {
            instance = tagDef.createInstance();
        }
        catch (InstantiationException ex) {
            throw new SAXException("Failed to create tag element '" + localName + "': " + ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new SAXException("Failed to create tag element '" + localName + "': " + ex.getMessage());
        }
        Attributes attributes = localElement.getAttributes();
        int numAttributes = attributes.getLength();
        for (int i = 0; i < numAttributes; ++i) {
            String attrName = attributes.getLocalName(i);
            AttributeDefinition attr = tagDef.getAttribute(attrName);
            if (attr == null) continue;
            Method setter = attr.getSetter();
            try {
                BeanUtils.invokeSetter(instance, setter, attributes.getValue(i));
                continue;
            }
            catch (BeanException ex) {
                ex.printStackTrace();
                throw new SAXException("Failed to set attribute '" + attrName + "' for tag '" + localName + "': " + ex.getMessage(), ex);
            }
        }
        localElement.setData(instance);
        if (parentElement != null) {
            String propertyName = this.attributeName2PropertyName(localName);
            Object parentObject = parentElement.getData();
            ComplexTypeDefinition parentTagDef = parentElement.getTypeDefinition();
            ElementDefinition elem = parentTagDef.getElementDefinition(propertyName);
            if (elem == null) {
                if (parentObject instanceof List) {
                    ((List)parentObject).add(instance);
                    return;
                }
                if (parentObject instanceof Set) {
                    ((Set)parentObject).add(instance);
                    return;
                }
                throw new SAXException("Failed to set unknown element '" + propertyName + "' for tag '" + parentElement.getName() + "'.");
            }
            Method setter = elem.getSetter();
            try {
                BeanUtils.invokeSetter(parentObject, setter, instance);
            }
            catch (BeanException ex) {
                ex.printStackTrace();
                throw new SAXException("Failed to set element '" + propertyName + "' for tag '" + parentElement.getName() + "': " + ex.getMessage());
            }
        }
    }

    public void endElement(BaseObjectSerializer.StackElement localElement, String content, BaseObjectSerializer.StackElement parentElement, Object root) throws SAXException {
        String localName = localElement.getName();
        Object localData = localElement.getData();
        ComplexTypeDefinition tagDef = localElement.getTypeDefinition();
        String bodyPropertyName = tagDef.getBodyProperty();
        if (bodyPropertyName != null) {
            try {
                BeanUtils.setProperty(localData, bodyPropertyName, content);
            }
            catch (BeanException ex) {
                throw new SAXException("Failed to attribute '" + bodyPropertyName + "' for tag '" + localName + "': " + ex.getMessage(), ex);
            }
        }
    }

    public String attributeName2PropertyName(String attributeName) {
        StringBuffer propertyNameBuf = new StringBuffer(attributeName.length());
        StringTokenizer tkn = new StringTokenizer(attributeName, "-");
        while (tkn.hasMoreTokens()) {
            String token = tkn.nextToken();
            if (propertyNameBuf.length() == 0) {
                propertyNameBuf.append(token);
                continue;
            }
            propertyNameBuf.append(Character.toUpperCase(token.charAt(0))).append(token.substring(1));
        }
        return propertyNameBuf.toString();
    }

    public String propertyName2AttributeName(String propertyName) {
        StringBuffer attributeNameBuf = new StringBuffer(propertyName.length() + 5);
        int propertyNameLen = propertyName.length();
        int lastTokenStart = 0;
        for (int i = 0; i < propertyNameLen; ++i) {
            char c = propertyName.charAt(i);
            if (c < 'A' || c > 'Z') continue;
            attributeNameBuf.append(propertyName.substring(lastTokenStart, i)).append('-').append(Character.toLowerCase(c));
            lastTokenStart = i + 1;
        }
        attributeNameBuf.append(propertyName.substring(lastTokenStart));
        return attributeNameBuf.toString();
    }
}

