/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.web.servlet;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Result;
import org.ujac.print.DocumentTransformHelper;
import org.ujac.util.UjacException;
import org.ujac.util.io.ClassPathResourceLoader;
import org.ujac.util.io.FileUtils;
import org.ujac.util.template.TemplateInterpreter;
import org.ujac.util.text.FormatHelper;
import org.ujac.web.servlet.TemplateInterpreterHelper;

public class ServletDocumentTransformHelper {
    private DocumentTransformHelper documentTransformHelper = new DocumentTransformHelper();
    File tempFile = null;
    FileOutputStream fos = null;

    public DocumentTransformHelper getTransformHelper() {
        return this.documentTransformHelper;
    }

    public Result prepare(HttpServletRequest request, boolean supportToc) throws IOException, UjacException {
        this.tempFile = null;
        FileOutputStream fos = null;
        try {
            TemplateInterpreter interpreter = TemplateInterpreterHelper.getTemplateInterpreter(request);
            this.documentTransformHelper.setTemplateInterpreter(interpreter);
            FormatHelper fh = TemplateInterpreterHelper.getFormatHelper(request);
            this.documentTransformHelper.setFormatHelper(fh);
            if (this.documentTransformHelper.getResourceLoader() == null) {
                ClassPathResourceLoader resourceLoader = new ClassPathResourceLoader(this.getClass().getClassLoader());
                this.documentTransformHelper.setResourceLoader(resourceLoader);
            }
            this.tempFile = File.createTempFile("ujac_print", "pdf");
            fos = new FileOutputStream(this.tempFile);
            BufferedOutputStream os = new BufferedOutputStream(fos);
            return this.documentTransformHelper.prepare(os, supportToc);
        }
        catch (IOException ex) {
            if (fos != null) {
                fos.close();
            }
            if (this.tempFile != null && !this.tempFile.delete()) {
                this.tempFile.deleteOnExit();
            }
            throw ex;
        }
        catch (UjacException ex) {
            if (fos != null) {
                fos.close();
            }
            if (this.tempFile != null && !this.tempFile.delete()) {
                this.tempFile.deleteOnExit();
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(HttpServletResponse response) throws UjacException, IOException {
        try {
            this.documentTransformHelper.finish();
            long pdfSize = this.tempFile.length();
            response.setContentLength((int)pdfSize);
            response.setContentType("application/pdf");
            FileUtils.copyToStream(this.tempFile, (OutputStream)response.getOutputStream());
        }
        finally {
            if (this.fos != null) {
                this.fos.close();
            }
            if (this.tempFile != null && !this.tempFile.delete()) {
                this.tempFile.deleteOnExit();
            }
        }
    }
}

