/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.web.servlet;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import org.ujac.util.template.DefaultTemplateInterpreterFactory;
import org.ujac.util.template.TemplateContext;
import org.ujac.util.template.TemplateInterpreter;
import org.ujac.util.template.TemplateInterpreterFactory;
import org.ujac.util.text.FormatHelper;

public class TemplateInterpreterHelper {
    public static final String ATTR_TEMPLATE_INTERPRETER_FACTORY = "org.ujac.template.factory";
    public static final String ATTR_FORMAT_HELPER = "org.ujac.format.helper";
    public static final String ATTR_EXPRESSION_PROPERTIES = "ujac-expression-properties";

    public static TemplateInterpreterFactory getTemplateInterpreterFactory(HttpServletRequest request) {
        TemplateInterpreterFactory factory = (TemplateInterpreterFactory)request.getAttribute(ATTR_TEMPLATE_INTERPRETER_FACTORY);
        if (factory == null) {
            factory = new DefaultTemplateInterpreterFactory();
            request.setAttribute(ATTR_TEMPLATE_INTERPRETER_FACTORY, (Object)factory);
        }
        return factory;
    }

    public static TemplateInterpreterFactory getTemplateInterpreterFactory(PageContext pageContext) {
        TemplateInterpreterFactory factory = (TemplateInterpreterFactory)pageContext.findAttribute(ATTR_TEMPLATE_INTERPRETER_FACTORY);
        if (factory == null) {
            factory = new DefaultTemplateInterpreterFactory();
            pageContext.setAttribute(ATTR_TEMPLATE_INTERPRETER_FACTORY, (Object)factory, 1);
        }
        return factory;
    }

    public static TemplateInterpreter getTemplateInterpreter(HttpServletRequest request) {
        return TemplateInterpreterHelper.getTemplateInterpreterFactory(request).createTemplateInterpreter();
    }

    public static TemplateInterpreter getTemplateInterpreter(PageContext pageContext) {
        return TemplateInterpreterHelper.getTemplateInterpreterFactory(pageContext).createTemplateInterpreter();
    }

    public static FormatHelper getFormatHelper(HttpServletRequest request) {
        FormatHelper formatHelper = (FormatHelper)request.getAttribute(ATTR_FORMAT_HELPER);
        if (formatHelper == null) {
            formatHelper = FormatHelper.createInstance(request.getLocale());
            request.setAttribute(ATTR_FORMAT_HELPER, (Object)formatHelper);
        }
        return formatHelper;
    }

    public static FormatHelper getFormatHelper(PageContext pageContext) {
        FormatHelper formatHelper = (FormatHelper)pageContext.findAttribute(ATTR_FORMAT_HELPER);
        if (formatHelper == null) {
            formatHelper = FormatHelper.createInstance(pageContext.getRequest().getLocale());
            pageContext.setAttribute(ATTR_FORMAT_HELPER, (Object)formatHelper, 1);
        }
        return formatHelper;
    }

    public static Map getExpressionProperties(HttpServletRequest request) {
        HashMap<String, Object> props = (HashMap<String, Object>)request.getAttribute(ATTR_EXPRESSION_PROPERTIES);
        if (props == null) {
            String name;
            props = new HashMap<String, Object>();
            HttpSession session = request.getSession();
            Enumeration enumAttributes = session.getAttributeNames();
            while (enumAttributes.hasMoreElements()) {
                name = (String)enumAttributes.nextElement();
                props.put(name, session.getAttribute(name));
            }
            enumAttributes = request.getAttributeNames();
            while (enumAttributes.hasMoreElements()) {
                name = (String)enumAttributes.nextElement();
                props.put(name, request.getAttribute(name));
            }
            request.setAttribute(ATTR_EXPRESSION_PROPERTIES, props);
        }
        return props;
    }

    public static Map getExpressionProperties(PageContext pageContext) {
        HashMap<String, Object> props = (HashMap<String, Object>)pageContext.findAttribute(ATTR_EXPRESSION_PROPERTIES);
        if (props == null) {
            String name;
            props = new HashMap<String, Object>();
            Enumeration enumAttributes = pageContext.getAttributeNamesInScope(3);
            while (enumAttributes.hasMoreElements()) {
                name = (String)enumAttributes.nextElement();
                props.put(name, pageContext.getAttribute(name, 3));
            }
            enumAttributes = pageContext.getAttributeNamesInScope(1);
            while (enumAttributes.hasMoreElements()) {
                name = (String)enumAttributes.nextElement();
                props.put(name, pageContext.getAttribute(name, 1));
            }
            enumAttributes = pageContext.getAttributeNamesInScope(2);
            while (enumAttributes.hasMoreElements()) {
                name = (String)enumAttributes.nextElement();
                props.put(name, pageContext.getAttribute(name, 2));
            }
            pageContext.setAttribute(ATTR_EXPRESSION_PROPERTIES, props, 1);
        }
        TemplateInterpreterHelper.addDefaultProperties(props);
        return props;
    }

    public static TemplateContext createTemplateContext(HttpServletRequest request) {
        Map properties = TemplateInterpreterHelper.getExpressionProperties(request);
        FormatHelper formatHelper = TemplateInterpreterHelper.getFormatHelper(request);
        return TemplateInterpreterHelper.getTemplateInterpreterFactory(request).createTemplateContext(properties, formatHelper);
    }

    public static TemplateContext createTemplateContext(PageContext pageContext) {
        Map properties = TemplateInterpreterHelper.getExpressionProperties(pageContext);
        FormatHelper formatHelper = TemplateInterpreterHelper.getFormatHelper(pageContext);
        return TemplateInterpreterHelper.getTemplateInterpreterFactory(pageContext).createTemplateContext(properties, formatHelper);
    }

    public static TemplateContext getTemplateContext(PageContext pageContext, Tag tag) {
        TemplateContext ctx = (TemplateContext)pageContext.getAttribute("TEMPLATE_CONTEXT", 1);
        if (ctx != null) {
            return ctx;
        }
        ctx = TemplateInterpreterHelper.createTemplateContext(pageContext);
        pageContext.setAttribute("TEMPLATE_CONTEXT", (Object)ctx, 1);
        return ctx;
    }

    protected static void addDefaultProperties(Map properties) {
        Date currentDate = new Date();
        properties.put("today", currentDate);
        properties.put("now", new Timestamp(currentDate.getTime()));
    }
}

