/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSValueUtilities;
import com.webobjects.foundation.NSVersion;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSThreadsafeMutableDictionary;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation.development.NSBundleFactory;
import com.webobjects.foundation.development.NSLegacyBundle;
import com.webobjects.foundation.development.NSStandardProjectBundle;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NSBundle
implements NSVersion {
    public static final String NS_GLOBAL_PROPERTIES_PATH = "NSGlobalPropertiesPath";
    private static final String LEGACY_GLOBAL_PROPERTIES_PATH = "WebObjectsPropertiesReplacement";
    public static final String CFBUNDLESHORTVERSIONSTRINGKEY = "CFBundleShortVersionString";
    public static final String MANIFESTIMPLEMENTATIONVERSIONKEY = "Implementation-Version";
    public static final String BundleDidLoadNotification = "NSBundleDidLoadNotification";
    public static final String AllBundlesDidLoadNotification = "NSBundleAllDidLoadNotification";
    public static final String LoadedClassesNotification = "NSLoadedClassesNotification";
    private static final String userDirPath;
    public static final String LPROJSUFFIX = ".lproj";
    private static final String NONLOCALIZED_LOCALE = "Nonlocalized.lproj";
    private static final String NONLOCALIZED_LOCALE_PREFIX;
    private static final String RESOURCES = "Resources";
    private static final NSMutableArray<NSBundle> AllBundles;
    private static final NSMutableArray<NSBundle> AllBundlesReally;
    private static final NSMutableArray<NSBundle> AllFrameworks;
    private static final NSMutableDictionary<String, NSBundle> BundlesClassesTable;
    private static NSArray<String> ClassPath;
    private static final NSMutableDictionary<String, NSBundle> BundlesNamesTable;
    private static final NSMutableDictionary<String, NSBundle> AppBundlesNamesTable;
    private static NSBundle MainBundle;
    private static boolean PrincipalClassLookupAllowed;
    private static final _NSThreadsafeMutableDictionary ResourceDirectoryFilters;
    private static final _NSThreadsafeMutableDictionary ResourceFilters;
    protected static final DirectoryFilter TheDirectoryFilter;
    protected static final FilesFilter TheFilesFilter;
    public static final String InfoPlistFilename = "Info.plist";
    private static String ResourcesInfoPlist;
    private static String JarResourcesInfoPlist;
    private static String ResourcesProperties;
    private static boolean safeInvokeDeprecatedJarBundleAPI;
    private Class principalClass;
    private static final String jarEndsWithString;
    protected Integer _version;
    protected Integer _revision;
    protected Integer _fix;
    protected Integer _build;
    protected String _releaseString;
    protected static final Integer _zeroInteger;

    static {
        NSArray bundleFactories;
        NONLOCALIZED_LOCALE_PREFIX = NONLOCALIZED_LOCALE + File.separator;
        AllBundles = new NSMutableArray(64);
        AllBundlesReally = new NSMutableArray(64);
        AllFrameworks = new NSMutableArray(64);
        BundlesClassesTable = new NSMutableDictionary(2048);
        BundlesNamesTable = new NSMutableDictionary(16);
        AppBundlesNamesTable = new NSMutableDictionary(1);
        ResourceDirectoryFilters = new _NSThreadsafeMutableDictionary(new NSMutableDictionary());
        ResourceFilters = new _NSThreadsafeMutableDictionary(new NSMutableDictionary());
        TheDirectoryFilter = new DirectoryFilter();
        TheFilesFilter = new FilesFilter();
        ResourcesInfoPlist = "Resources/Info.plist";
        JarResourcesInfoPlist = "!/" + ResourcesInfoPlist;
        ResourcesProperties = "Resources/Properties";
        safeInvokeDeprecatedJarBundleAPI = false;
        jarEndsWithString = ".jar".concat(JarResourcesInfoPlist);
        _zeroInteger = new Integer(0);
        NSBundleFactory.registerBundleFactory(new NSLegacyBundle.Factory());
        if (NSValueUtilities.booleanValue(System.getProperty("NSProjectBundleEnabled"))) {
            NSBundleFactory.registerBundleFactory(new NSStandardProjectBundle.Factory());
        }
        if ((bundleFactories = NSValueUtilities.arrayValue(System.getProperty("NSBundleFactories"))) != null) {
            for (String bundleFactory : bundleFactories) {
                try {
                    NSBundleFactory.registerBundleFactory(Class.forName(bundleFactory).asSubclass(NSBundleFactory.class).newInstance());
                }
                catch (Throwable t) {
                    throw new IllegalArgumentException("Failed to create the bundle factory: " + bundleFactory + ".", t);
                }
            }
        }
        try {
            String urlPath;
            safeInvokeDeprecatedJarBundleAPI = NSPropertyListSerialization.booleanForString((String)NSProperties.getProperty("com.webobjects.safeInvokeDeprecatedJarBundleAPI"));
            String woUserDir = NSProperties.getProperty("webobjects.user.dir");
            if (woUserDir == null) {
                woUserDir = System.getProperty("user.dir");
            }
            userDirPath = new File(woUserDir).getCanonicalPath();
            NSMutableArray urlArray = new NSMutableArray();
            Enumeration<URL> e = NSBundle.class.getClassLoader().getResources(ResourcesInfoPlist);
            while (e.hasMoreElements()) {
                urlPath = NSBundle.__exctractStringFromURL(e.nextElement());
                if (urlPath == null) continue;
                urlArray.addObject((Object)urlPath);
            }
            if (urlArray.count() == 0) {
                e = ClassLoader.getSystemResources(ResourcesInfoPlist);
                while (e.hasMoreElements()) {
                    urlPath = NSBundle.__exctractStringFromURL(e.nextElement());
                    if (urlPath == null) continue;
                    urlArray.addObject((Object)urlPath);
                }
            }
            NSBundle.LoadBundlesFromJars((NSArray)urlArray);
            NSMutableArray classpath = NSArray._mutableComponentsSeparatedByString((String)(String.valueOf(System.getProperty("java.class.path")) + File.pathSeparator + NSProperties.getProperty("com.webobjects.classpath")), (String)File.pathSeparator);
            NSMutableArray cleanedUpClassPath = new NSMutableArray();
            Iterator iterator = classpath.iterator();
            while (iterator.hasNext()) {
                String fixedComponent = NSPathUtilities.stringByNormalizingExistingPath((String)((String)iterator.next()));
                if (fixedComponent == null || fixedComponent.length() <= 0) continue;
                cleanedUpClassPath.add((Object)fixedComponent);
            }
            int i = cleanedUpClassPath.count() - 1;
            while (i >= 0) {
                String component = (String)cleanedUpClassPath.objectAtIndex(i);
                if (cleanedUpClassPath.indexOfObject((Object)component) != i) {
                    cleanedUpClassPath.removeObjectAtIndex(i);
                }
                --i;
            }
            ClassPath = cleanedUpClassPath;
            NSBundle.LoadBundlesFromClassPath(ClassPath);
            NSBundle.InitMainBundle();
            NSBundle.LoadUserAndBundleProperties();
            NSBundle.InitPrincipalClasses();
            NSNotificationCenter.defaultCenter().postNotification(AllBundlesDidLoadNotification, null, null);
            _NSUtilities._setResourceSearcher(new _NSUtilities._ResourceSearcher(){

                public Class _searchForClassWithName(String className) {
                    return NSBundle.searchAllBundlesForClassWithName(className);
                }

                public URL _searchPathURLForResourceWithName(Class resourceClass, String resourceName, String extension) {
                    URL url = null;
                    NSBundle bundle = NSBundle.bundleForClass(resourceClass);
                    if (bundle != null && resourceName != null) {
                        String fileName = null;
                        fileName = extension == null || extension.length() == 0 ? resourceName : (extension.startsWith(".") || resourceName.endsWith(".") ? resourceName.concat(extension) : _NSStringUtilities.concat(resourceName, ".", extension));
                        bundle.pathURLForResourcePath(bundle.resourcePathForLocalizedResourceNamed(fileName, ""));
                    }
                    return url;
                }
            });
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable(e);
        }
    }

    private static final String __exctractStringFromURL(URL anURL) {
        String url2Path = null;
        try {
            String urlPath = anURL.getPath();
            if (urlPath.endsWith(jarEndsWithString)) {
                url2Path = urlPath.substring(0, urlPath.length() - JarResourcesInfoPlist.length());
                URL url2 = new URL(url2Path);
                url2Path = url2.getPath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url2Path;
    }

    @Deprecated
    public static synchronized NSArray allBundles() {
        return AllBundles.immutableClone();
    }

    @Deprecated
    public static NSArray<NSBundle> allFrameworks() {
        return NSBundle.frameworkBundles();
    }

    public static synchronized NSBundle bundleForClass(Class aClass) {
        NSBundle bundle = null;
        if (aClass != null) {
            bundle = (NSBundle)BundlesClassesTable.objectForKey((Object)aClass.getName());
        }
        return bundle;
    }

    @Deprecated
    public static NSBundle bundleWithPath(String aPath) {
        return NSBundle._bundleWithPathShouldCreateIsJar(aPath, false, false);
    }

    public static NSBundle _bundleWithPathShouldCreateIsJar(String aPath, boolean shouldCreateBundle, boolean newIsJar) {
        return NSBundleFactory.bundleForPathWithRegistry(aPath, shouldCreateBundle, newIsJar);
    }

    public static synchronized NSBundle bundleForName(String aName) {
        NSBundle bundle = null;
        if (aName != null) {
            String fixedName = aName.endsWith(".framework") ? NSPathUtilities.stringByDeletingPathExtension((String)aName) : aName;
            bundle = (NSBundle)BundlesNamesTable.objectForKey((Object)fixedName);
        }
        return bundle;
    }

    public static synchronized NSBundle _appBundleForName(String aName) {
        NSBundle bundle = null;
        if (aName != null) {
            String fixedName = aName.endsWith(".woa") ? NSPathUtilities.stringByDeletingPathExtension((String)aName) : aName;
            bundle = (NSBundle)AppBundlesNamesTable.objectForKey((Object)fixedName);
        }
        return bundle;
    }

    public static synchronized NSBundle _bundleOrAppForName(String name) {
        NSBundle bundle = NSBundle.bundleForName(name);
        if (bundle == null) {
            bundle = NSBundle._appBundleForName(name);
        }
        return bundle;
    }

    public static synchronized NSArray<NSBundle> frameworkBundles() {
        return AllFrameworks.immutableClone();
    }

    public static void _setMainBundle(NSBundle bundle) {
        MainBundle = bundle;
    }

    public static NSBundle mainBundle() {
        return MainBundle;
    }

    private static void transferPropertiesFromSourceToDest(Properties sourceProps, Properties destProps) {
        if (sourceProps != null) {
            destProps.putAll((Map<?, ?>)sourceProps);
        }
    }

    public static Properties _userAndBundleProperties() {
        Properties nextProps = null;
        Properties bundleProps = new Properties();
        NSProperties.NestedProperties userProps = null;
        Properties oldSysProps = NSProperties._getProperties();
        String userhome = System.getProperty("user.home");
        NSArray<NSBundle> allBundles = NSBundle.allFrameworks();
        Enumeration bundleEn = allBundles.objectEnumerator();
        while (bundleEn.hasMoreElements()) {
            NSBundle nextBundle = (NSBundle)bundleEn.nextElement();
            nextProps = nextBundle.properties();
            NSBundle.transferPropertiesFromSourceToDest(nextProps, bundleProps);
        }
        if (NSBundle.mainBundle() != null) {
            nextProps = NSBundle.mainBundle().properties();
        }
        NSBundle.transferPropertiesFromSourceToDest(nextProps, bundleProps);
        nextProps = bundleProps;
        boolean validateProperties = NSBundle.shouldValidateProperties();
        boolean globalPropertiesPathOverride = false;
        NSMutableArray filesToCheck = new NSMutableArray();
        String wopropsfile = System.getProperty(NS_GLOBAL_PROPERTIES_PATH);
        if (wopropsfile == null) {
            wopropsfile = System.getProperty(LEGACY_GLOBAL_PROPERTIES_PATH);
        }
        if (wopropsfile != null && wopropsfile.length() > 0) {
            if (userhome != null && userhome.length() > 0 && !new File(wopropsfile).isAbsolute()) {
                filesToCheck.addObject((Object)new File(userhome, wopropsfile));
            }
            filesToCheck.addObject((Object)new File(wopropsfile));
            globalPropertiesPathOverride = true;
        } else if (userhome != null && userhome.length() > 0) {
            filesToCheck.addObject((Object)new File(userhome, "WebObjects.properties"));
        }
        File propsFile = null;
        int i = 0;
        while (i < filesToCheck.count()) {
            boolean loadGlobalProperties;
            propsFile = (File)filesToCheck.objectAtIndex(i);
            if (validateProperties && globalPropertiesPathOverride) {
                loadGlobalProperties = true;
            } else {
                boolean bl = loadGlobalProperties = propsFile.exists() && propsFile.isFile() && propsFile.canRead();
            }
            if (loadGlobalProperties) {
                try {
                    userProps = new NSProperties.NestedProperties(null);
                    if (bundleProps != null) {
                        userProps.putAll((Map<?, ?>)bundleProps);
                    }
                    userProps.load(propsFile, NSProperties._shouldRequireSymlinkedGlobalAndIncludeProperties());
                }
                catch (Exception e) {
                    if (validateProperties) {
                        throw new RuntimeException("Failed to load '" + propsFile + "'.", e);
                    }
                    userProps = null;
                    NSLog.err.appendln((Throwable)e);
                }
                if (i == 2) {
                    NSLog.err.appendln((Object)("Could not read specified NSGlobalPropertiesPath file (" + wopropsfile + ").  Falling back to " + propsFile));
                }
                if (userProps != null) break;
            }
            ++i;
        }
        if (userProps != null) {
            nextProps = userProps;
        } else {
            if (globalPropertiesPathOverride && validateProperties) {
                throw new RuntimeException("There was no global properties file '" + wopropsfile + "'.");
            }
            NSLog.err.appendln((Object)("Couldn't load properties file: " + propsFile + " at path: " + userhome));
        }
        Properties sysProps = new Properties();
        sysProps.putAll((Map<?, ?>)nextProps);
        NSBundle.transferPropertiesFromSourceToDest(oldSysProps, sysProps);
        return sysProps;
    }

    private static void LoadUserAndBundleProperties() {
        NSProperties._setProperties(NSBundle._userAndBundleProperties());
    }

    private static void InitMainBundle() {
        try {
            String mainBundleName = NSProperties._mainBundleName();
            if (mainBundleName != null) {
                MainBundle = NSBundle.bundleForName(mainBundleName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (MainBundle == null) {
            MainBundle = NSBundleFactory.bundleForPathWithRegistry(userDirPath, true, false);
        }
        if (MainBundle == null) {
            MainBundle = NSBundle.bundleForName("JavaFoundation");
        }
        if (!(MainBundle == null || MainBundle.infoDictionary() != null && _NSUtilities.safeEquals(MainBundle.name(), (String)MainBundle.infoDictionary().objectForKey((Object)"NSExecutable")))) {
            throw new IllegalStateException("There was no name defined for the bundle '" + MainBundle + "'");
        }
    }

    @Deprecated
    public static void _setPrincipalClassWarningSuppressed(boolean flag) {
    }

    private static void InitPrincipalClasses() {
        int count = AllBundlesReally.count();
        int i = 0;
        while (i < count) {
            ((NSBundle)AllBundlesReally.objectAtIndex(i))._bundlesDidLoad();
            ((NSBundle)AllBundlesReally.objectAtIndex(i)).initPrincipalClass();
            ++i;
        }
        PrincipalClassLookupAllowed = true;
    }

    private static void LoadBundlesFromJars(NSArray array) {
        Enumeration en = array.objectEnumerator();
        while (en.hasMoreElements()) {
            NSBundleFactory.bundleForPathWithRegistry(en.nextElement().toString(), true, true);
        }
    }

    private static void LoadBundlesFromClassPath(NSArray<String> array) {
        Enumeration en = array.objectEnumerator();
        while (en.hasMoreElements()) {
            String nextPathComponent = (String)en.nextElement();
            NSBundleFactory.bundleForPathWithRegistry(nextPathComponent, true, false);
        }
    }

    public static String _DefaultLocalePrefix() {
        String defaultLang = "English";
        String defaultLocaleLang = Locale.getDefault().getLanguage();
        if (defaultLocaleLang.equals("de")) {
            defaultLang = "German";
        } else if (defaultLocaleLang.equals("es")) {
            defaultLang = "Spanish";
        } else if (defaultLocaleLang.equals("fr")) {
            defaultLang = "French";
        } else if (defaultLocaleLang.equals("ja")) {
            defaultLang = "Japanese";
        }
        return defaultLang.concat(LPROJSUFFIX);
    }

    public static synchronized NSBundle _lookupBundleWithPath(String aPath) {
        NSBundle bundle = null;
        if (aPath == null) {
            return null;
        }
        Enumeration en = AllBundlesReally.objectEnumerator();
        while (en.hasMoreElements() && bundle == null) {
            NSBundle nextBundle = (NSBundle)en.nextElement();
            if (!nextBundle.bundlePath().equals(aPath)) continue;
            bundle = nextBundle;
        }
        return bundle;
    }

    public static String _normalizeExistingBundlePath(String aPath) {
        File fileAtPath;
        String standardizedPath = null;
        if (aPath != null && (fileAtPath = new File(aPath)).exists()) {
            standardizedPath = NSPathUtilities.stringByNormalizingExistingPath((String)aPath);
        }
        return standardizedPath;
    }

    public static String _cleanNormalizedBundlePath(String standardizedPath) {
        String bundlePath = standardizedPath;
        if (bundlePath != null) {
            String allDirectoriesInPath = null;
            int i = -1;
            File fileAtPath = new File(bundlePath);
            allDirectoriesInPath = !fileAtPath.isDirectory() ? _NSStringUtilities.stringByDeletingLastComponent(bundlePath, File.separatorChar) : bundlePath;
            if (allDirectoriesInPath != null) {
                i = allDirectoriesInPath.lastIndexOf(NSLegacyBundle.RJSUFFIX);
                if (i == -1 || i == 0) {
                    i = allDirectoriesInPath.lastIndexOf(NSLegacyBundle.RSUFFIX);
                }
                if (i == -1 || i == 0) {
                    bundlePath = allDirectoriesInPath;
                } else {
                    bundlePath = allDirectoriesInPath.substring(0, i);
                    if (NSPathUtilities.lastPathComponent((String)NSPathUtilities.stringByDeletingLastPathComponent((String)bundlePath)).equals("Versions")) {
                        bundlePath = NSPathUtilities.stringByDeletingLastPathComponent((String)NSPathUtilities.stringByDeletingLastPathComponent((String)bundlePath));
                    }
                }
            }
        }
        return bundlePath;
    }

    public static NSArray<NSBundle> _allBundlesReally() {
        return AllBundlesReally;
    }

    public static synchronized void addBundle(NSBundle bundle) {
        if (AllBundlesReally.containsObject((Object)bundle)) {
            return;
        }
        boolean bundleAdded = true;
        if (bundle.isFramework()) {
            NSBundle possibleBundle = NSBundle.bundleForName(bundle.name());
            if (possibleBundle == null) {
                BundlesNamesTable.setObjectForKey((Object)bundle, (Object)bundle.name());
                AllFrameworks.addObject((Object)bundle);
            } else {
                bundleAdded = false;
                System.err.println("<" + NSBundle.class.getName() + "> warning: There is already a unique instance for Bundle named '" + bundle.name() + "' at the path + '" + possibleBundle.bundlePath() + "'. Skipping the version located at '" + bundle.bundlePath() + "'.");
            }
        } else {
            AppBundlesNamesTable.setObjectForKey((Object)bundle, (Object)bundle.name());
            MainBundle = bundle;
            AllBundles.addObject((Object)bundle);
        }
        if (bundleAdded) {
            AllBundlesReally.addObject((Object)bundle);
            bundle.initVersion();
            if (PrincipalClassLookupAllowed) {
                bundle._bundlesDidLoad();
                bundle.initPrincipalClass();
            }
            NSNotificationCenter.defaultCenter().postNotification(BundleDidLoadNotification, (Object)bundle, new NSDictionary(bundle.bundleClassNames(), (Object)LoadedClassesNotification));
        }
    }

    public static String _userDirPath() {
        return userDirPath;
    }

    public static NSArray<String> _classPath() {
        return ClassPath;
    }

    public static synchronized void _registerClassNameForBundle(String className, NSBundle bundle) {
        NSBundle existingBundle = (NSBundle)BundlesClassesTable.objectForKey((Object)className);
        if (existingBundle == null) {
            BundlesClassesTable.setObjectForKey((Object)bundle, (Object)className);
        }
    }

    protected static ResourceDirectoryFilter ResourceDirectoryFilterForExtension(String anExtension) {
        ResourceDirectoryFilter rdf = null;
        if (anExtension == null) {
            throw new IllegalArgumentException("Illegal resource search: cannot search using a null extension");
        }
        String correctedExtension = anExtension.startsWith(".") ? anExtension.substring(1) : anExtension;
        rdf = (ResourceDirectoryFilter)ResourceDirectoryFilters.objectForKey((Object)correctedExtension);
        if (rdf == null) {
            rdf = new ResourceDirectoryFilter(correctedExtension);
            ResourceDirectoryFilters.setObjectForKey((Object)rdf, (Object)correctedExtension);
        }
        return rdf;
    }

    protected static ResourceFilter ResourceFilterForExtension(String anExtension) {
        ResourceFilter rf = null;
        if (anExtension == null) {
            throw new IllegalArgumentException("Illegal resource search: cannot search using a null extension");
        }
        String correctedExtension = anExtension.startsWith(".") ? anExtension.substring(1) : anExtension;
        rf = (ResourceFilter)ResourceFilters.objectForKey((Object)correctedExtension);
        if (rf == null) {
            rf = new ResourceFilter(correctedExtension);
            ResourceFilters.setObjectForKey((Object)rf, (Object)correctedExtension);
        }
        return rf;
    }

    static Class searchAllBundlesForClassWithName(String className) {
        if (NSLog._debugLoggingAllowedForLevelAndGroups((int)2, (long)32L)) {
            NSLog.debug.appendln((Object)("NSBundle.searchAllBundlesForClassWithName(\"" + className + "\") was invoked.\n\t**This affects performance very badly.**"));
            if (NSLog.debug.allowedDebugLevel() > 2) {
                NSLog.debug.appendln((Throwable)new RuntimeException("NSBundle.searchAllBundlesForClassWithName was invoked."));
            }
        }
        Class result = null;
        result = NSBundle.searchForClassInBundles(className, NSBundle.allBundles(), true);
        if (result == null) {
            result = NSBundle.searchForClassInBundles(className, NSBundle.allFrameworks(), true);
        }
        return result;
    }

    private static Class searchForClassInBundles(String className, NSArray bundles, boolean registerPackageOnHit) {
        int count = bundles.count();
        int i = 0;
        while (i < count) {
            NSArray<String> packages = ((NSBundle)bundles.objectAtIndex(i)).bundleClassPackageNames();
            Class result = _NSUtilities._searchForClassInPackages(className, packages, registerPackageOnHit, false);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public abstract NSArray<String> bundleClassPackageNames();

    @Deprecated
    public abstract String bundlePath();

    public abstract URL bundlePathURL();

    public abstract String _bundleURLPrefix();

    public byte[] bytesForResourcePath(String aResourcePath) {
        InputStream is = this.inputStreamForResourcePath(aResourcePath);
        byte[] b = null;
        if (is == null) {
            b = new byte[]{};
        } else {
            try {
                b = _NSStringUtilities.bytesFromInputStream(is);
            }
            catch (Exception e) {
                throw NSForwardException._runtimeExceptionForThrowable(e);
            }
        }
        return b;
    }

    public abstract NSArray<String> bundleClassNames();

    @Deprecated
    public abstract NSDictionary<String, Object> infoDictionary();

    public NSDictionary<String, Object> _infoDictionary() {
        return this.infoDictionary();
    }

    public URL pathURLForResourcePath(String aResourcePath) {
        return this._pathURLForResourcePath(aResourcePath, true);
    }

    public abstract URL _pathURLForResourcePath(String var1, boolean var2);

    public InputStream inputStreamForResourcePath(String aResourcePath) {
        InputStream is = null;
        URL url = this._pathURLForResourcePath(aResourcePath, false);
        if (url != null) {
            try {
                is = url.openStream();
            }
            catch (IOException ioe) {
                throw NSForwardException._runtimeExceptionForThrowable(ioe);
            }
        }
        return is;
    }

    public abstract boolean isFramework();

    public abstract boolean _isCFBundle();

    public abstract boolean isJar();

    public abstract JarFile _jarFile();

    public abstract NSDictionary _jarFileLayout();

    @Deprecated
    public abstract boolean load();

    public abstract String name();

    public boolean _directoryExistsInJar(String path) {
        if (path == null) {
            return false;
        }
        if (path.length() == 0) {
            return true;
        }
        if (this.isJar()) {
            String aPath = path;
            if (!aPath.endsWith("/")) {
                aPath = aPath.concat("/");
            }
            if (File.separatorChar != '/') {
                aPath = aPath.replace(File.separatorChar, '/');
            }
            return this._jarFile().getEntry(aPath) != null;
        }
        return false;
    }

    protected void initVersion() {
        NSDictionary<String, Object> infoPlist = this._infoDictionary();
        String aBuildString = null;
        String aVersion = null;
        if (infoPlist != null) {
            aVersion = (String)infoPlist.valueForKey(CFBUNDLESHORTVERSIONSTRINGKEY);
            aBuildString = (String)infoPlist.valueForKey(MANIFESTIMPLEMENTATIONVERSIONKEY);
        }
        this.parseVersionString(aVersion, aBuildString);
    }

    protected void parseVersionString(String aVersion, String aBuildString) {
        String releaseString;
        Integer build;
        Integer fix;
        Integer revision;
        Integer version;
        block13: {
            version = new Integer(1);
            revision = _zeroInteger;
            fix = _zeroInteger;
            build = _zeroInteger;
            releaseString = "";
            try {
                build = aBuildString != null && aBuildString.length() > 0 ? Integer.valueOf(aBuildString) : _zeroInteger;
            }
            catch (Exception e) {
                if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)32L)) break block13;
                NSLog.debug.appendln((Object)("The bundle " + this.name() + " has malformed build number: " + aBuildString));
            }
        }
        if (aVersion != null && aVersion.trim().length() > 0) {
            try {
                StringBuilder numeric = new StringBuilder(32);
                StringBuilder adjective = new StringBuilder(32);
                boolean found = false;
                char[] cArray = aVersion.trim().toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (!found && (Character.isDigit(c) || c == '.')) {
                        numeric.append(c);
                    } else {
                        found = true;
                        adjective.append(c);
                    }
                    ++n2;
                }
                StringTokenizer versionTokenizer = new StringTokenizer(numeric.toString(), ".", false);
                if (versionTokenizer.hasMoreTokens()) {
                    version = new Integer(versionTokenizer.nextToken());
                }
                if (versionTokenizer.hasMoreTokens()) {
                    revision = new Integer(versionTokenizer.nextToken());
                }
                if (versionTokenizer.hasMoreTokens()) {
                    fix = new Integer(versionTokenizer.nextToken());
                }
                releaseString = adjective.toString();
            }
            catch (Exception exception) {
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)32L)) {
                    NSLog.debug.appendln((Object)("Exception " + exception));
                }
            }
        } else {
            NSLog.err.appendln((Object)("The bundle " + this.name() + " has malformed version number: " + aVersion));
        }
        this._version = version;
        this._revision = revision;
        this._fix = fix;
        this._build = build;
        this._releaseString = releaseString;
    }

    @Override
    public Integer version() {
        return this._version != null ? this._version : new Integer(1);
    }

    @Override
    public Integer revision() {
        return this._revision != null ? this._revision : new Integer(0);
    }

    @Override
    public Integer fix() {
        return this._fix != null ? this._fix : new Integer(0);
    }

    @Override
    public Integer build() {
        return this._build != null ? this._build : new Integer(0);
    }

    @Override
    public int compareTo(NSVersion object) throws ClassCastException {
        return NSVersion.DefaultImplementation.compareTo(this, object);
    }

    @Override
    public String versionString() {
        return NSVersion.DefaultImplementation.toString(this);
    }

    @Override
    public String releaseString() {
        return this._releaseString != null ? this._releaseString : "";
    }

    @Deprecated
    public String pathForResource(String aName, String anExtension) {
        return this.pathForResource(aName, anExtension, null);
    }

    @Deprecated
    public abstract String pathForResource(String var1, String var2, String var3);

    @Deprecated
    public abstract NSArray pathsForResources(String var1, String var2);

    public Class principalClass() {
        return this.principalClass;
    }

    public abstract Properties properties();

    @Deprecated
    public abstract String resourcePath();

    public URL _urlForRelativePath(String path) {
        URL retVal = null;
        if (path != null && path.length() > 0) {
            if (this.isJar()) {
                ZipEntry ze;
                String aPath = path;
                if (aPath.startsWith("/")) {
                    aPath = aPath.substring(1, aPath.length());
                }
                if ((ze = this._jarFile().getEntry(aPath)) == null && !aPath.endsWith("/")) {
                    aPath = aPath.concat("/");
                    ze = this._jarFile().getEntry(aPath);
                }
                if (ze != null) {
                    try {
                        retVal = new URL(this._bundleURLPrefix().concat(aPath));
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            } else {
                File f = new File(_NSStringUtilities.concat(this.bundlePath(), File.separator, path));
                if (f.exists()) {
                    try {
                        retVal = f.toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        }
        return retVal;
    }

    public abstract String resourcePathForLocalizedResourceNamed(String var1, String var2);

    protected String resourcePathForLocalizedResourceNamed(String aName, String aSubDirPath, List<String> resourceBuckets) {
        String path = null;
        if (aName != null) {
            String FileSeparator = this.isJar() ? "/" : File.separator;
            Iterator<String> en = resourceBuckets.iterator();
            String localePrefix = NSBundle._DefaultLocalePrefix().concat(FileSeparator);
            String[] pathFragments = new String[2];
            if (aSubDirPath == null || aSubDirPath.length() == 0) {
                pathFragments[0] = localePrefix;
                pathFragments[1] = "";
            } else {
                pathFragments[0] = _NSStringUtilities.concat(localePrefix, aSubDirPath, FileSeparator);
                pathFragments[1] = aSubDirPath.concat(FileSeparator);
            }
            while (en.hasNext() && path == null) {
                String nextDir = en.next();
                String pathPrefix = nextDir.equals("") ? this.bundlePath().concat(FileSeparator) : _NSStringUtilities.concat(this.bundlePath(), FileSeparator, nextDir, FileSeparator);
                int i = 0;
                while (i < pathFragments.length && path == null) {
                    block15: {
                        String possiblePath;
                        if (this.isJar()) {
                            possiblePath = _NSStringUtilities.concat(FileSeparator, pathFragments[i], aName);
                            String comparisonPath = nextDir.concat(possiblePath);
                            ZipEntry ze = this._jarFile().getEntry(comparisonPath);
                            if (ze != null) {
                                path = pathFragments[i].concat(aName);
                                if (!pathFragments[i].startsWith(NSBundle._DefaultLocalePrefix())) {
                                    path = NONLOCALIZED_LOCALE.concat(possiblePath);
                                }
                            }
                        } else {
                            possiblePath = pathFragments[i].equals("") ? pathPrefix.concat(aName) : _NSStringUtilities.concat(pathPrefix, pathFragments[i], aName);
                            File possibleResource = new File(possiblePath);
                            File possibleResourcePrefix = new File(pathPrefix);
                            if (possibleResource.exists() && possibleResourcePrefix.isDirectory()) {
                                try {
                                    path = possibleResource.getCanonicalPath();
                                    String absolutePathPrefix = possibleResourcePrefix.getCanonicalPath();
                                    if (!absolutePathPrefix.endsWith(File.separator)) {
                                        absolutePathPrefix = String.valueOf(absolutePathPrefix) + File.separator;
                                    }
                                    if (path.startsWith(absolutePathPrefix)) {
                                        path = path.substring(absolutePathPrefix.length());
                                        if (!pathFragments[i].startsWith(NSBundle._DefaultLocalePrefix())) {
                                            path = NONLOCALIZED_LOCALE_PREFIX.concat(path);
                                        }
                                        break block15;
                                    }
                                    throw new IllegalArgumentException("<" + NSLegacyBundle.class.getName() + "> May not pass relative paths that reference resources outside of the bundle! (" + aName + "," + aSubDirPath + ")");
                                }
                                catch (IOException e) {
                                    throw NSForwardException._runtimeExceptionForThrowable(e);
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        return path;
    }

    public abstract NSArray<String> resourcePathsForDirectories(String var1, String var2);

    public abstract NSArray<String> resourcePathsForLocalizedResources(String var1, String var2);

    public abstract NSArray<String> resourcePathsForResources(String var1, String var2);

    protected boolean _prefixPathWithNonLocalizedPrefix(String aPath, String resourcePath) {
        return aPath.equals(resourcePath);
    }

    public String toString() {
        int count = 0;
        if (this.bundleClassNames() != null) {
            count = this.bundleClassNames().count();
        }
        return "<" + this.getClass().getName() + " name:'" + this.name() + "' bundlePath:'" + this.bundlePath() + "' packages:'" + this.bundleClassPackageNames() + "' " + count + " classes >";
    }

    public Class _classWithName(String className) {
        Class objectClass = null;
        if (className == null) {
            throw new IllegalArgumentException("Class name cannot be null.");
        }
        objectClass = _NSUtilities._classWithPartialName(className, false);
        if (objectClass != null) {
            return objectClass;
        }
        NSArray<String> thePackages = this.bundleClassPackageNames();
        objectClass = _NSUtilities._searchForClassInPackages(className, thePackages, true, false);
        return objectClass != null ? objectClass : _NSUtilities._classWithPartialName(className, true);
    }

    protected NSArray<String> resourcePathsForResourcesInDirectory(String aPath, String resourcePath, FilenameFilter aFilter, boolean prependNonlocalizedLProj) {
        File subdir = new File(aPath);
        String[] fileNames = subdir.list(aFilter);
        if (fileNames == null) {
            return NSArray.emptyArray();
        }
        String prefix = this._prefixPathWithNonLocalizedPrefix(aPath, resourcePath) ? "" : aPath.substring(resourcePath.concat(File.separator).length());
        NSMutableArray list = new NSMutableArray();
        int i = 0;
        while (i < fileNames.length) {
            if (prefix.length() == 0) {
                list.addObject((Object)NONLOCALIZED_LOCALE_PREFIX.concat(fileNames[i]));
            } else if (prependNonlocalizedLProj) {
                list.addObject((Object)_NSStringUtilities.concat(NONLOCALIZED_LOCALE_PREFIX, prefix, File.separator, fileNames[i]));
            } else {
                list.addObject((Object)_NSStringUtilities.concat(prefix, File.separator, fileNames[i]));
            }
            ++i;
        }
        String[] dirNames = subdir.list(TheDirectoryFilter);
        int i2 = 0;
        while (i2 < dirNames.length) {
            boolean prepend = prefix.length() == 0 ? !dirNames[i2].endsWith(LPROJSUFFIX) : prependNonlocalizedLProj;
            list.addObjectsFromArray(this.resourcePathsForResourcesInDirectory(_NSStringUtilities.concat(aPath, File.separator, dirNames[i2]), resourcePath, aFilter, prepend));
            ++i2;
        }
        if (list.count() == 0) {
            return NSArray.emptyArray();
        }
        return list;
    }

    public abstract void _simplePathsInDirectoryInJar(String var1, String var2, NSMutableArray<String> var3, String var4, NSMutableArray<String> var5);

    protected NSArray<String> resourcePathsForDirectoriesInDirectory(String aPath, String resourcePath, FilenameFilter aFilter, boolean prependNonlocalizedLProj) {
        String[] dirNames = new File(aPath).list(aFilter);
        if (dirNames == null) {
            return NSArray.emptyArray();
        }
        NSMutableArray list = new NSMutableArray();
        String prefix = this._prefixPathWithNonLocalizedPrefix(aPath, resourcePath) ? "" : aPath.substring(resourcePath.concat(File.separator).length());
        int i = 0;
        while (i < dirNames.length) {
            if (prefix.length() == 0) {
                if (dirNames[i].endsWith(LPROJSUFFIX)) {
                    list.addObject((Object)dirNames[i]);
                } else {
                    list.addObject((Object)NONLOCALIZED_LOCALE_PREFIX.concat(dirNames[i]));
                }
            } else if (prependNonlocalizedLProj) {
                list.addObject((Object)_NSStringUtilities.concat(NONLOCALIZED_LOCALE_PREFIX, prefix, File.separator, dirNames[i]));
            } else {
                list.addObject((Object)_NSStringUtilities.concat(prefix, File.separator, dirNames[i]));
            }
            ++i;
        }
        i = 0;
        while (i < dirNames.length) {
            if (prefix.length() == 0) {
                boolean endWithLPROJ = dirNames[i].endsWith(LPROJSUFFIX);
                list.addObjectsFromArray(this.resourcePathsForDirectoriesInDirectory(_NSStringUtilities.concat(aPath, File.separator, dirNames[i]), resourcePath, aFilter, !endWithLPROJ));
            } else {
                list.addObjectsFromArray(this.resourcePathsForDirectoriesInDirectory(_NSStringUtilities.concat(aPath, File.separator, dirNames[i]), resourcePath, aFilter, prependNonlocalizedLProj));
            }
            ++i;
        }
        if (list.count() == 0) {
            return NSArray.emptyArray();
        }
        return list;
    }

    public abstract void _bundlesDidLoad();

    public void initPrincipalClass() {
        String principalClassName = null;
        this.principalClass = null;
        if (this.infoDictionary() != null && (principalClassName = (String)this.infoDictionary().objectForKey((Object)"NSPrincipalClass")) != null && !principalClassName.equals("") && !"true".equals(System.getProperty("NSSkipPrincipalClasses"))) {
            this.principalClass = _NSUtilities.classWithName(principalClassName);
            if (this.principalClass == null && _NSUtilities._principalClassLoadingWarningsNeeded) {
                NSLog.err.appendln((Object)("Principal class '" + principalClassName + "' not found in bundle " + this.name()));
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)32L)) {
                    NSLog.debug.appendln((Throwable)new ClassNotFoundException(principalClassName));
                }
            }
        }
    }

    protected static boolean shouldValidateProperties() {
        return Boolean.valueOf(System.getProperty("NSValidateProperties", "true"));
    }

    protected static boolean _bundleUrlExists(URL url) {
        boolean urlPathExists;
        block10: {
            urlPathExists = true;
            try {
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    File file = new File(url.getFile());
                    urlPathExists = file.exists();
                    break block10;
                }
                if ("jar".equals(protocol)) {
                    JarURLConnection urlConn = (JarURLConnection)url.openConnection();
                    URL jarFileURL = urlConn.getJarFileURL();
                    if (NSBundle._bundleUrlExists(jarFileURL)) {
                        if ("file".equals(jarFileURL.getProtocol())) {
                            JarFile jarFile = new JarFile(jarFileURL.getPath());
                            try {
                                JarEntry jarEntry = (JarEntry)jarFile.getEntry(urlConn.getEntryName());
                                if (jarEntry == null) {
                                    urlPathExists = false;
                                }
                                break block10;
                            }
                            finally {
                                jarFile.close();
                            }
                        }
                        throw new IllegalArgumentException("Unable to handle Jar File URL protocol: " + url);
                    }
                    urlPathExists = false;
                    break block10;
                }
                throw new IllegalArgumentException("Unable to handle URL protocol: " + url);
            }
            catch (IOException e) {
                urlPathExists = true;
            }
        }
        return urlPathExists;
    }

    protected static class DirectoryFilter
    implements FilenameFilter {
        protected DirectoryFilter() {
        }

        public boolean accept(File dir, String aName) {
            boolean result = false;
            if (aName != null && !aName.equals(".svn")) {
                File namedFile = new File(dir, aName);
                result = namedFile.isDirectory();
            }
            return result;
        }
    }

    protected static class FilesFilter
    implements FilenameFilter {
        protected FilesFilter() {
        }

        public boolean accept(File dir, String aName) {
            boolean result = false;
            if (aName != null && !aName.equals(".svn")) {
                File namedFile = new File(dir, aName);
                result = namedFile.isFile();
            }
            return result;
        }
    }

    protected static class OldResourceFilter
    implements FilenameFilter {
        private String extension;

        public OldResourceFilter(String anExtension) {
            this.extension = "." + anExtension;
        }

        public boolean accept(File dir, String aName) {
            boolean result = false;
            if (aName != null && aName.endsWith(this.extension)) {
                result = true;
            }
            return result;
        }
    }

    protected static class ResourceDirectoryFilter
    implements FilenameFilter {
        private String extension;

        public ResourceDirectoryFilter(String anExtension) {
            this.extension = "." + anExtension;
        }

        public boolean accept(File dir, String aName) {
            File d;
            boolean result = false;
            if (aName != null && !aName.equals(".svn") && (d = new File(dir + File.separator + aName)).isDirectory() && aName.endsWith(this.extension)) {
                result = true;
            }
            return result;
        }
    }

    protected static class ResourceFilter
    implements FilenameFilter {
        private String extension;

        public ResourceFilter(String anExtension) {
            this.extension = "." + anExtension;
        }

        public boolean accept(File dir, String aName) {
            File f;
            boolean result = false;
            if (aName != null && (f = new File(dir, aName)).isFile() && aName.endsWith(this.extension)) {
                result = true;
            }
            return result;
        }
    }

    protected static class SpecificResourceFilter
    implements FilenameFilter {
        private String name;

        public SpecificResourceFilter(String aName) {
            this.name = String.valueOf(aName) + ".";
        }

        public boolean accept(File dir, String aName) {
            boolean result = false;
            if (aName != null && aName.startsWith(this.name)) {
                result = true;
            }
            return result;
        }
    }
}

