/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;

public class _NSFileUtilities {
    public static final Logger log = Logger.getLogger(_NSFileUtilities.class);

    protected static void freeProcessResources(Process p) {
        if (p != null) {
            try {
                if (p.getInputStream() != null) {
                    p.getInputStream().close();
                }
                if (p.getOutputStream() != null) {
                    p.getOutputStream().close();
                }
                if (p.getErrorStream() != null) {
                    p.getErrorStream().close();
                }
                p.destroy();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static File resolveLink(String path, String linkName) {
        int retry = NSProperties.intForKeyWithDefault("NSFileUtilities.resolveLinkRetryPeriod", 5000);
        int timeout = NSProperties.intForKeyWithDefault("NSFileUtilities.resolveLinkTimeoutPeriod", 60000);
        return _NSFileUtilities.resolveLink(path, linkName, retry, timeout);
    }

    public static File resolveLink(String path, String linkName, int retry, int timeout) {
        File resolvedPath;
        boolean debuggingEnabled = NSProperties.booleanForKeyWithDefault("NSFileUtilities.debugMissingCurrentLinks", false);
        if (debuggingEnabled) {
            log.info((Object)("Resolving link (" + linkName + ") for: " + path));
        }
        try {
            File f = new File(path);
            boolean isNamedLink = f.getName().toLowerCase().equals(linkName.toLowerCase());
            long timeoutPoint = System.currentTimeMillis() + (long)timeout;
            if (debuggingEnabled) {
                log.info((Object)("Testing isNamedLink: " + f.getName() + " == " + linkName + " ==> " + (isNamedLink ? "true" : "false")));
            }
            while (true) {
                if (debuggingEnabled) {
                    String output;
                    block21: {
                        output = "";
                        String[] cmd = new String[]{"stat", "-F", f.getPath()};
                        Process task = null;
                        try {
                            try {
                                task = Runtime.getRuntime().exec(cmd);
                                while (true) {
                                    try {
                                        task.waitFor();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        continue;
                                    }
                                    break;
                                }
                                BufferedReader out = new BufferedReader(new InputStreamReader(task.getInputStream()));
                                output = out.readLine();
                                if (task.exitValue() != 0) {
                                    BufferedReader err = new BufferedReader(new InputStreamReader(task.getErrorStream()));
                                    output = String.valueOf(output) + "ERROR: " + err.readLine();
                                }
                            }
                            catch (Throwable t) {
                                log.info((Object)"Failed to run stat with exception", t);
                                _NSFileUtilities.freeProcessResources(task);
                                break block21;
                            }
                        }
                        catch (Throwable throwable) {
                            _NSFileUtilities.freeProcessResources(task);
                            throw throwable;
                        }
                        _NSFileUtilities.freeProcessResources(task);
                    }
                    log.info((Object)("debugMissingCurrentLinks: stat output: " + output));
                }
                resolvedPath = f.getCanonicalFile();
                if (debuggingEnabled) {
                    log.info((Object)("Fetched resolved path: " + resolvedPath));
                }
                if (!isNamedLink || !resolvedPath.getName().toLowerCase().equals(linkName.toLowerCase())) {
                    if (debuggingEnabled) {
                        log.info((Object)"resolveLink succeeded");
                    }
                } else {
                    if (debuggingEnabled) {
                        log.info((Object)"resolveLink failed");
                    }
                    if (System.currentTimeMillis() + (long)retry < timeoutPoint) {
                        Thread.sleep(retry);
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to safely resolve current path: " + path, e);
        }
        return resolvedPath;
    }
}

