/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.zeroturnaround.javarebel.Resource;
import org.zeroturnaround.javarebel.support.ResourceUtils;

public class FileResource
implements Resource {
    private final File file;
    private final URL url;

    public FileResource(File file) {
        this.file = file;
        try {
            this.url = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public FileResource(URL url) {
        this.url = url;
        this.file = ResourceUtils.getFile(url);
    }

    public byte[] getBytes() {
        FileInputStream is;
        try {
            is = new FileInputStream(this.file);
        }
        catch (FileNotFoundException e1) {
            throw new RuntimeException(e1);
        }
        try {
            int offset;
            long length = this.file.length();
            if (length > Integer.MAX_VALUE) {
                // empty if block
            }
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + this.file.getName());
            }
            byte[] byArray = bytes;
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public String toString() {
        return this.url.toString();
    }

    public URL toURL() {
        return this.url;
    }
}

