/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.dbutil;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.objectstyle.ashwood.dbutil.Column;
import org.objectstyle.ashwood.dbutil.ForeignKey;
import org.objectstyle.ashwood.dbutil.PrimaryKey;
import org.objectstyle.ashwood.dbutil.Sequence;
import org.objectstyle.ashwood.dbutil.Table;
import org.objectstyle.ashwood.graph.Algorithm;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.Digraph;
import org.objectstyle.ashwood.graph.GraphUtils;
import org.objectstyle.ashwood.graph.IndegreeTopologicalSort;
import org.objectstyle.ashwood.graph.MapDigraph;
import org.objectstyle.ashwood.random.Roulette;

public class RandomSchema {
    private boolean acyclic = true;
    private Digraph schemaGraph;
    private int tableCount = 10;
    private int maxReferencesPerTable = 3;
    private int maxForeignKeysPerTable = 3;
    private Random randomizer = new Random();
    private List tables = Collections.EMPTY_LIST;
    private String schemaName;
    private String catalog;
    private Map sequencesByTable = Collections.EMPTY_MAP;
    private int maxLoopsPerTable = 0;
    private int loopCount = 0;

    public boolean isAcyclic() {
        return this.acyclic;
    }

    public void setAcyclic(boolean bl) {
        this.acyclic = bl;
    }

    public void generate() {
        this.schemaGraph = new MapDigraph(MapDigraph.HASHMAP_FACTORY);
        this.generateAcyclicSchema();
    }

    private void generateAcyclicSchema() {
        Object object;
        Serializable serializable;
        Roulette roulette;
        MapDigraph mapDigraph = new MapDigraph(MapDigraph.HASHMAP_FACTORY);
        HashMap<Integer, Table> hashMap = new HashMap<Integer, Table>();
        GraphUtils.randomizeAcyclic(mapDigraph, this.tableCount, this.maxForeignKeysPerTable, this.maxReferencesPerTable, this.randomizer);
        this.tables = new ArrayList(this.tableCount);
        this.sequencesByTable = new HashMap(this.tableCount);
        IndegreeTopologicalSort indegreeTopologicalSort = new IndegreeTopologicalSort(mapDigraph);
        ArrayList<Object> arrayList = new ArrayList<Object>(mapDigraph.order());
        while (((Algorithm)indegreeTopologicalSort).hasNext()) {
            arrayList.add(((Algorithm)indegreeTopologicalSort).next());
        }
        if (this.loopCount > 0 && this.maxLoopsPerTable > 0) {
            roulette = new Roulette(arrayList.size(), 1, this.randomizer);
            int n = Math.min(this.loopCount, arrayList.size());
            while (n > 0) {
                serializable = (Number)roulette.next();
                object = arrayList.get(((Number)serializable).intValue());
                mapDigraph.putArc(object, object, Boolean.TRUE);
                --n;
            }
        }
        roulette = arrayList.iterator();
        while (roulette.hasNext()) {
            Integer n = (Integer)roulette.next();
            serializable = this.generateTable(n, mapDigraph);
            hashMap.put(n, (Table)serializable);
            this.schemaGraph.addVertex(serializable);
        }
        ArcIterator arcIterator = mapDigraph.arcIterator();
        while (arcIterator.hasNext()) {
            arcIterator.next();
            serializable = hashMap.get(arcIterator.getOrigin());
            object = hashMap.get(arcIterator.getDestination());
            this.schemaGraph.putArc(serializable, object, Boolean.TRUE);
        }
    }

    private Table generateTable(Integer n, Digraph digraph) {
        Serializable serializable;
        Object object;
        Table table = new Table(this.catalog, this.schemaName, "TABLE" + n);
        int n2 = digraph.outgoingSize(n);
        int n3 = digraph.incomingSize(n);
        if (n2 != 0 || n2 == 0 && n3 == 0) {
            object = new Column();
            ((Column)object).setName(table.getName() + "_ID");
            ((Column)object).setTypeName("INTEGER");
            ((Column)object).setNullable(0);
            table.addColumn((Column)object);
            serializable = new PrimaryKey((Column)object);
            table.addPrimaryKey((PrimaryKey)serializable);
            this.sequencesByTable.put(table, new Sequence(table.getName() + "_SEQ"));
        }
        object = digraph.incomingIterator(n);
        while (object.hasNext()) {
            object.next();
            serializable = (Integer)object.getOrigin();
            String string = "TABLE" + serializable;
            String string2 = string + "_ID";
            String string3 = string + "_PK";
            int n4 = !n.equals(serializable) ? 1 : this.generateFkCountForLoop();
            int n5 = 1;
            while (n5 <= n4) {
                Serializable serializable2;
                String string4 = String.valueOf(n5);
                Column column = new Column();
                column.setName(string2 + string4);
                column.setTypeName("INTEGER");
                column.setNullable(0);
                table.addColumn(column);
                if (n2 == 0) {
                    serializable2 = new PrimaryKey(column);
                    table.addPrimaryKey((PrimaryKey)serializable2);
                }
                serializable2 = new ForeignKey(column);
                ((ForeignKey)serializable2).setPkColumnName(string2);
                ((ForeignKey)serializable2).setPkName(string3);
                ((ForeignKey)serializable2).setPkTableCatalog(this.catalog);
                ((ForeignKey)serializable2).setPkTableName(string);
                ((ForeignKey)serializable2).setPkTableSchema(this.schemaName);
                table.addForeignKey((ForeignKey)serializable2);
                ++n5;
            }
        }
        this.tables.add(table);
        return table;
    }

    private int generateFkCountForLoop() {
        int n = this.randomizer.nextInt(this.maxLoopsPerTable) + 1;
        return n;
    }

    public Digraph getSchemaGraph() {
        return this.schemaGraph;
    }

    public void setTableCount(int n) {
        this.tableCount = n;
    }

    public int getTableCount() {
        return this.tableCount;
    }

    public void setMaxReferencesPerTable(int n) {
        this.maxReferencesPerTable = n;
    }

    public int getMaxReferencesPerTable() {
        return this.maxReferencesPerTable;
    }

    public void setMaxForeignKeysPerTable(int n) {
        this.maxForeignKeysPerTable = n;
    }

    public int getMaxForeignKeysPerTable() {
        return this.maxForeignKeysPerTable;
    }

    public void setRandomizer(Random random) {
        this.randomizer = random;
    }

    public Random getRandomizer() {
        return this.randomizer;
    }

    public List getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public Map getSequencesByTable() {
        return Collections.unmodifiableMap(this.sequencesByTable);
    }

    public void setMaxLoopsPerTable(int n) {
        this.maxLoopsPerTable = n;
    }

    public int getMaxLoopsPerTable() {
        return this.maxLoopsPerTable;
    }

    public void setLoopCount(int n) {
        this.loopCount = n;
    }

    public int getLoopCount() {
        return this.loopCount;
    }
}

