/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph.layout;

import java.util.HashMap;
import java.util.Map;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.Digraph;
import org.objectstyle.ashwood.graph.IndegreeTopologicalSort;
import org.objectstyle.ashwood.graph.layout.RankFunction;

public class TopologicalRankFunction
implements RankFunction {
    private int maxRank = -1;
    private Map vertexRankMap;

    public TopologicalRankFunction(Digraph digraph) {
        this.init(digraph);
    }

    private void init(Digraph digraph) {
        this.vertexRankMap = new HashMap(digraph.order());
        IndegreeTopologicalSort indegreeTopologicalSort = new IndegreeTopologicalSort(digraph);
        while (indegreeTopologicalSort.hasNext()) {
            Object object = indegreeTopologicalSort.next();
            int n = -1;
            ArcIterator arcIterator = digraph.incomingIterator(object);
            while (arcIterator.hasNext()) {
                arcIterator.next();
                Object object2 = arcIterator.getOrigin();
                int n2 = this.intValue(object2);
                if (n2 < 0) {
                    throw new ArithmeticException("Ranking failed.");
                }
                n = Math.max(n, n2);
            }
            this.assignRank(object, ++n);
        }
    }

    public void assignRank(Object object, int n) {
        this.vertexRankMap.put(object, new Integer(n));
        this.maxRank = Math.max(this.maxRank, n);
    }

    public int maxRank() {
        return this.maxRank;
    }

    public int intValue(Object object) {
        Number number = (Number)this.vertexRankMap.get(object);
        return number != null ? number.intValue() : Integer.MIN_VALUE;
    }
}

