/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne;

import java.io.Serializable;
import java.util.List;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.ObjectContext;
import org.objectstyle.cayenne.Persistent;
import org.objectstyle.cayenne.access.ToManyList;
import org.objectstyle.cayenne.query.RelationshipQuery;

public abstract class Fault
implements Serializable {
    protected static final Fault toOneFault = new ToOneFault();
    protected static final Fault toManyFault = new ToManyFault();

    public static Fault getToOneFault() {
        return toOneFault;
    }

    public static Fault getToManyFault() {
        return toManyFault;
    }

    protected Fault() {
    }

    public abstract Object resolveFault(Persistent var1, String var2);

    static final class ToOneFault
    extends Fault {
        ToOneFault() {
        }

        public Object resolveFault(Persistent sourceObject, String relationshipName) {
            RelationshipQuery query;
            ObjectContext context = sourceObject.getObjectContext();
            List objects = context.performQuery(query = new RelationshipQuery(sourceObject.getObjectId(), relationshipName, false));
            if (objects.isEmpty()) {
                return null;
            }
            if (objects.size() == 1) {
                return objects.get(0);
            }
            throw new CayenneRuntimeException("Error resolving to-one fault. More than one object found. Source Id: " + sourceObject.getObjectId() + ", relationship: " + relationshipName);
        }
    }

    static final class ToManyFault
    extends Fault {
        ToManyFault() {
        }

        public Object resolveFault(Persistent sourceObject, String relationshipName) {
            return new ToManyList(sourceObject, relationshipName);
        }
    }
}

