/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne;

import org.objectstyle.cayenne.DataChannel;
import org.objectstyle.cayenne.ObjectContext;
import org.objectstyle.cayenne.event.EventManager;
import org.objectstyle.cayenne.event.EventSubject;
import org.objectstyle.cayenne.graph.GraphEventListener;

public class ObjectContextUtils {
    static final EventSubject[] CONTEXT_SUBJECTS = new EventSubject[]{ObjectContext.GRAPH_CHANGED_SUBJECT, ObjectContext.GRAPH_COMMIT_ABORTED_SUBJECT, ObjectContext.GRAPH_COMMIT_STARTED_SUBJECT, ObjectContext.GRAPH_COMMITTED_SUBJECT, ObjectContext.GRAPH_ROLLEDBACK_SUBJECT};
    static final EventSubject[] CHANNEL_SUBJECTS = new EventSubject[]{DataChannel.GRAPH_CHANGED_SUBJECT, DataChannel.GRAPH_COMMITTED_SUBJECT, DataChannel.GRAPH_ROLLEDBACK_SUBJECT};
    static /* synthetic */ Class class$org$objectstyle$cayenne$graph$GraphEvent;

    public static boolean listenForContextEvents(DataChannel channel, GraphEventListener listener) {
        EventManager manager = channel.getEventManager();
        if (manager == null) {
            return false;
        }
        ObjectContextUtils.listenForSubjects(manager, listener, null, CONTEXT_SUBJECTS);
        return true;
    }

    public static boolean listenForContextEvents(ObjectContext context, GraphEventListener listener) {
        if (context.getChannel() == null || context.getChannel().getEventManager() == null) {
            return false;
        }
        ObjectContextUtils.listenForSubjects(context.getChannel().getEventManager(), listener, context, CONTEXT_SUBJECTS);
        return true;
    }

    public static boolean listenForChannelEvents(DataChannel channel, GraphEventListener listener) {
        EventManager manager = channel.getEventManager();
        if (manager == null) {
            return false;
        }
        ObjectContextUtils.listenForSubjects(manager, listener, channel, CHANNEL_SUBJECTS);
        return true;
    }

    public static boolean listenForChannelEvents(EventManager manager, GraphEventListener listener) {
        if (manager == null) {
            return false;
        }
        ObjectContextUtils.listenForSubjects(manager, listener, null, CHANNEL_SUBJECTS);
        return true;
    }

    static void listenForSubjects(EventManager manager, GraphEventListener listener, Object sender, EventSubject[] subjects) {
        for (int i = 0; i < subjects.length; ++i) {
            String fqSubject = subjects[i].getSubjectName();
            String method = fqSubject.substring(fqSubject.lastIndexOf(47) + 1);
            manager.addListener(listener, method, class$org$objectstyle$cayenne$graph$GraphEvent == null ? ObjectContextUtils.class$("org.objectstyle.cayenne.graph.GraphEvent") : class$org$objectstyle$cayenne$graph$GraphEvent, subjects[i], sender);
        }
    }

    private ObjectContextUtils() {
    }
}

