/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.access.DataContext;
import org.objectstyle.cayenne.access.DataDomain;
import org.objectstyle.cayenne.access.DataDomainFlushObserver;
import org.objectstyle.cayenne.access.DataNode;
import org.objectstyle.cayenne.access.DataNodeFlushAction;
import org.objectstyle.cayenne.access.DataNodeIndirectDiffBuilder;
import org.objectstyle.cayenne.access.DataRowStore;
import org.objectstyle.cayenne.access.ObjectStore;
import org.objectstyle.cayenne.access.ObjectStoreGraphDiff;
import org.objectstyle.cayenne.access.Transaction;
import org.objectstyle.cayenne.graph.CompoundDiff;
import org.objectstyle.cayenne.graph.GraphDiff;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.map.Entity;
import org.objectstyle.cayenne.map.ObjEntity;

class DataDomainFlushAction {
    static final boolean DONE = true;
    private final DataDomain domain;
    private Collection nodeActions;
    private Map changesByObjectId;
    private CompoundDiff resultDiff;
    private Collection resultDeletedIds;
    private Map resultModifiedSnapshots;
    private Collection resultIndirectlyModifiedIds;

    DataDomainFlushAction(DataDomain domain) {
        this.domain = domain;
    }

    DataDomain getDomain() {
        return this.domain;
    }

    Collection getResultDeletedIds() {
        return this.resultDeletedIds;
    }

    CompoundDiff getResultDiff() {
        return this.resultDiff;
    }

    Collection getResultIndirectlyModifiedIds() {
        return this.resultIndirectlyModifiedIds;
    }

    Map getResultModifiedSnapshots() {
        return this.resultModifiedSnapshots;
    }

    Map getChangesByObjectId() {
        return this.changesByObjectId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GraphDiff flush(DataContext context, GraphDiff changes) {
        if (changes == null) {
            return new CompoundDiff();
        }
        if (!(changes instanceof ObjectStoreGraphDiff)) {
            throw new IllegalArgumentException("Expected 'ObjectStoreGraphDiff', got: " + changes.getClass().getName());
        }
        this.changesByObjectId = ((ObjectStoreGraphDiff)changes).getChangesByObjectId();
        this.nodeActions = new ArrayList(2);
        DataRowStore dataRowStore = context.getObjectStore().getDataRowCache();
        synchronized (dataRowStore) {
            this.resultIndirectlyModifiedIds = new HashSet();
            if (this.preprocess(context, changes)) {
                return new CompoundDiff();
            }
            this.resultDiff = new CompoundDiff();
            this.resultDeletedIds = new ArrayList();
            this.resultModifiedSnapshots = new HashMap();
            DataDomainFlushObserver observer = new DataDomainFlushObserver();
            Transaction transaction = Transaction.getThreadTransaction();
            try {
                Iterator i = this.nodeActions.iterator();
                while (i.hasNext()) {
                    ((DataNodeFlushAction)i.next()).flush(observer);
                }
            }
            catch (Throwable th) {
                transaction.setRollbackOnly();
                throw new CayenneRuntimeException("Transaction was rolledback.", th);
            }
            this.postprocess(context);
            return this.resultDiff;
        }
    }

    DataNodeFlushAction getNodeAction(Entity entity) {
        DataNodeFlushAction action;
        DataMap dataMap = entity.getDataMap();
        DataNode node = this.domain.lookupDataNode(dataMap);
        Iterator it = this.nodeActions.iterator();
        while (it.hasNext()) {
            action = (DataNodeFlushAction)it.next();
            if (action.getNode() != node) continue;
            return action;
        }
        action = new DataNodeFlushAction(this, node);
        this.nodeActions.add(action);
        return action;
    }

    private boolean preprocess(DataContext context, GraphDiff changes) {
        ObjectStore objectStore = context.getObjectStore();
        Iterator<Object> it = this.changesByObjectId.keySet().iterator();
        while (it.hasNext()) {
            ObjectId id = (ObjectId)it.next();
            DataObject object = objectStore.getObject(id);
            ObjEntity entity = context.getEntityResolver().lookupObjEntity(id.getEntityName());
            this.getNodeAction(entity).addDirtyObject(object, entity);
        }
        Iterator it2 = this.nodeActions.iterator();
        while (it2.hasNext()) {
            ((DataNodeFlushAction)it2.next()).createPK();
        }
        new DataNodeIndirectDiffBuilder(this).processIndirectChanges(changes);
        it2 = this.nodeActions.iterator();
        while (it2.hasNext()) {
            ((DataNodeFlushAction)it2.next()).createQueries();
        }
        boolean done = true;
        it = this.nodeActions.iterator();
        while (it.hasNext()) {
            if (((DataNodeFlushAction)it.next()).isNoop()) continue;
            done = false;
            break;
        }
        return done;
    }

    private void postprocess(DataContext context) {
        Iterator i = this.nodeActions.iterator();
        while (i.hasNext()) {
            ((DataNodeFlushAction)i.next()).postprocess();
        }
        if (!(this.resultDeletedIds.isEmpty() && this.resultModifiedSnapshots.isEmpty() && this.resultIndirectlyModifiedIds.isEmpty())) {
            context.getObjectStore().getDataRowCache().processSnapshotChanges(context.getObjectStore(), this.resultModifiedSnapshots, this.resultDeletedIds, Collections.EMPTY_LIST, this.resultIndirectlyModifiedIds);
        }
    }
}

