/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.access.DataNodeDBDiffBuilder;
import org.objectstyle.cayenne.access.DataNodeFlushAction;
import org.objectstyle.cayenne.access.DataNodePKGenerationAction;
import org.objectstyle.cayenne.access.DataNodeSyncBucket;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.EntitySorter;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.query.InsertBatchQuery;

class DataNodeInsertBucket
extends DataNodeSyncBucket {
    private final boolean supportsGeneratedKeys;

    DataNodeInsertBucket(DataNodeFlushAction parent) {
        super(parent);
        this.supportsGeneratedKeys = parent.getNode().getAdapter().supportsGeneratedKeys();
    }

    void createPrimaryKey() {
        if (!this.isEmpty()) {
            DataNodePKGenerationAction pkAction = this.parent.getNode().pkGenerationAction();
            ArrayList insertedEntities = new ArrayList(this.objectsByEntity.keySet());
            Collections.sort(insertedEntities, pkAction.getObjEntityComparator());
            Iterator i = insertedEntities.iterator();
            while (i.hasNext()) {
                ObjEntity currentEntity = (ObjEntity)i.next();
                List dataObjects = (List)this.objectsByEntity.get(currentEntity);
                pkAction.createPermIdsForObjEntity(currentEntity, dataObjects);
            }
        }
    }

    void appendQueriesInternal(Collection queries) {
        DataNodeDBDiffBuilder diffBuilder = new DataNodeDBDiffBuilder(this.supportsGeneratedKeys);
        EntitySorter sorter = this.parent.getNode().getEntitySorter();
        sorter.sortDbEntities(this.dbEntities, false);
        Iterator i = this.dbEntities.iterator();
        while (i.hasNext()) {
            DbEntity dbEntity = (DbEntity)i.next();
            List objEntitiesForDbEntity = (List)this.objEntitiesByDbEntity.get(dbEntity);
            InsertBatchQuery batch = new InsertBatchQuery(dbEntity, 27);
            Iterator j = objEntitiesForDbEntity.iterator();
            while (j.hasNext()) {
                ObjEntity entity = (ObjEntity)j.next();
                diffBuilder.reset(entity, dbEntity);
                boolean isMasterDbEntity = entity.getDbEntity() == dbEntity;
                List objects = (List)(isMasterDbEntity ? this.objectsByEntity.get(entity) : this.objectsByEntity.remove(entity));
                if (objects.isEmpty()) continue;
                this.checkReadOnly(entity);
                if (isMasterDbEntity) {
                    sorter.sortObjectsForEntity(entity, objects, false);
                }
                Iterator k = objects.iterator();
                while (k.hasNext()) {
                    DataObject o = (DataObject)k.next();
                    Map snapshot = diffBuilder.buildDBDiff(this.parent.objectDiff(o.getObjectId()));
                    batch.add(snapshot, o.getObjectId());
                }
            }
            queries.add(batch);
        }
    }
}

