/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.map.DeleteRule;
import org.objectstyle.cayenne.map.ObjRelationship;

public class DeleteDenyException
extends CayenneRuntimeException {
    protected DataObject object;
    protected ObjRelationship relationship;

    public DeleteDenyException() {
    }

    public DeleteDenyException(String message) {
        super(message);
    }

    public DeleteDenyException(DataObject object, ObjRelationship relationship, String reason) {
        super(reason);
        this.object = object;
        this.relationship = relationship;
    }

    public DataObject getObject() {
        return this.object;
    }

    public ObjRelationship getRelationship() {
        return this.relationship;
    }

    public String getMessage() {
        String message;
        StringBuffer buffer = new StringBuffer();
        buffer.append("Can't delete object");
        if (this.object != null && this.object.getObjectId() != null) {
            buffer.append(" with OID ").append(this.object.getObjectId());
        }
        if (this.relationship != null) {
            buffer.append(". Reason: relationship '").append(this.relationship.getName()).append("' has ").append(DeleteRule.deleteRuleName(this.relationship.getDeleteRule()));
        }
        if ((message = super.getUnlabeledMessage()) != null) {
            buffer.append(". Details: ").append(message);
        }
        return buffer.toString();
    }
}

