/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access.jdbc;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.objectstyle.cayenne.CayenneException;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.DataRow;
import org.objectstyle.cayenne.access.ResultIterator;
import org.objectstyle.cayenne.access.jdbc.ColumnDescriptor;
import org.objectstyle.cayenne.access.jdbc.RowDescriptor;
import org.objectstyle.cayenne.access.types.ExtendedType;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.util.Util;

public class JDBCResultIterator
implements ResultIterator {
    protected Connection connection;
    protected Statement statement;
    protected ResultSet resultSet;
    protected RowDescriptor rowDescriptor;
    protected DbEntity rootEntity;
    protected int[] pkIndices;
    protected int mapCapacity;
    protected boolean closingConnection;
    protected boolean closed;
    protected boolean nextRow;
    protected int fetchedSoFar;
    protected int fetchLimit;

    public JDBCResultIterator(Connection connection, Statement statement, ResultSet resultSet, RowDescriptor descriptor, int fetchLimit) throws CayenneException {
        this.connection = connection;
        this.statement = statement;
        this.resultSet = resultSet;
        this.rowDescriptor = descriptor;
        this.fetchLimit = fetchLimit;
        this.mapCapacity = (int)Math.ceil((double)descriptor.getWidth() / 0.75);
        this.checkNextRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List dataRows(boolean close) throws CayenneException {
        ArrayList<Map> list = new ArrayList<Map>();
        try {
            while (this.hasNextRow()) {
                list.add(this.nextDataRow());
            }
        }
        finally {
            if (close) {
                this.close();
            }
        }
        return list;
    }

    public boolean hasNextRow() {
        return this.nextRow;
    }

    public Map nextDataRow() throws CayenneException {
        if (!this.hasNextRow()) {
            throw new CayenneException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        Map row = this.readDataRow();
        this.checkNextRow();
        return row;
    }

    public Map nextObjectId(DbEntity entity) throws CayenneException {
        if (!this.hasNextRow()) {
            throw new CayenneException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        if (this.rootEntity != entity || this.pkIndices == null) {
            this.rootEntity = entity;
            this.indexPK();
        }
        Map row = this.readIdRow();
        this.checkNextRow();
        return row;
    }

    public void skipDataRow() throws CayenneException {
        if (!this.hasNextRow()) {
            throw new CayenneException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        this.checkNextRow();
    }

    public void close() throws CayenneException {
        if (!this.closed) {
            this.nextRow = false;
            StringWriter errors = new StringWriter();
            PrintWriter out = new PrintWriter(errors);
            try {
                this.resultSet.close();
            }
            catch (SQLException e1) {
                out.println("Error closing ResultSet");
                e1.printStackTrace(out);
            }
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (SQLException e2) {
                    out.println("Error closing PreparedStatement");
                    e2.printStackTrace(out);
                }
            }
            if (this.connection != null && this.isClosingConnection()) {
                try {
                    this.connection.close();
                }
                catch (SQLException e3) {
                    out.println("Error closing Connection");
                    e3.printStackTrace(out);
                }
            }
            try {
                out.close();
                errors.close();
            }
            catch (IOException ioex) {
                // empty catch block
            }
            StringBuffer buf = errors.getBuffer();
            if (buf.length() > 0) {
                throw new CayenneException("Error closing ResultIterator: " + buf);
            }
            this.closed = true;
        }
    }

    public int getDataRowWidth() {
        return this.rowDescriptor.getWidth();
    }

    protected void checkNextRow() throws CayenneException {
        this.nextRow = false;
        try {
            if ((this.fetchLimit <= 0 || this.fetchedSoFar < this.fetchLimit) && this.resultSet.next()) {
                this.nextRow = true;
                ++this.fetchedSoFar;
            }
        }
        catch (SQLException e) {
            throw new CayenneException("Error rewinding ResultSet", e);
        }
    }

    protected Map readDataRow() throws CayenneException {
        try {
            DataRow dataRow = new DataRow(this.mapCapacity);
            ExtendedType[] converters = this.rowDescriptor.getConverters();
            ColumnDescriptor[] columns = this.rowDescriptor.getColumns();
            int resultWidth = this.rowDescriptor.getWidth();
            for (int i = 0; i < resultWidth; ++i) {
                Object val = converters[i].materializeObject(this.resultSet, i + 1, columns[i].getJdbcType());
                dataRow.put(columns[i].getLabel(), val);
            }
            return dataRow;
        }
        catch (CayenneException cex) {
            throw cex;
        }
        catch (Exception otherex) {
            throw new CayenneException("Exception materializing column.", Util.unwindException(otherex));
        }
    }

    protected Map readIdRow() throws CayenneException {
        try {
            DataRow idRow = new DataRow(2);
            ExtendedType[] converters = this.rowDescriptor.getConverters();
            ColumnDescriptor[] columns = this.rowDescriptor.getColumns();
            int len = this.pkIndices.length;
            for (int i = 0; i < len; ++i) {
                int index = this.pkIndices[i];
                Object val = converters[index].materializeObject(this.resultSet, index + 1, columns[index].getJdbcType());
                idRow.put(columns[index].getLabel(), val);
            }
            return idRow;
        }
        catch (CayenneException cex) {
            throw cex;
        }
        catch (Exception otherex) {
            throw new CayenneException("Exception materializing id column.", Util.unwindException(otherex));
        }
    }

    protected void indexPK() {
        if (this.rootEntity == null) {
            throw new CayenneRuntimeException("Null root DbEntity, can't index PK");
        }
        int len = this.rootEntity.getPrimaryKey().size();
        if (len == 0) {
            throw new CayenneRuntimeException("Root DbEntity has no PK defined: " + this.rootEntity);
        }
        int[] pk = new int[len];
        ColumnDescriptor[] columns = this.rowDescriptor.getColumns();
        int j = 0;
        for (int i = 0; i < columns.length; ++i) {
            DbAttribute a = (DbAttribute)this.rootEntity.getAttribute(columns[i].getName());
            if (a == null || !a.isPrimaryKey()) continue;
            pk[j++] = i;
        }
        this.pkIndices = pk;
    }

    public boolean isClosingConnection() {
        return this.closingConnection;
    }

    public void setClosingConnection(boolean flag) {
        this.closingConnection = flag;
    }

    public RowDescriptor getRowDescriptor() {
        return this.rowDescriptor;
    }
}

