/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access.trans;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.objectstyle.cayenne.dba.DbAdapter;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.query.BatchQuery;

public abstract class BatchQueryBuilder {
    protected DbAdapter adapter;
    protected String trimFunction;

    public BatchQueryBuilder() {
    }

    public BatchQueryBuilder(DbAdapter adapter) {
        this.adapter = adapter;
    }

    public abstract String createSqlString(BatchQuery var1);

    protected void appendDbAttribute(StringBuffer buf, DbAttribute dbAttribute) {
        boolean trim;
        boolean bl = trim = dbAttribute.getType() == 1 && this.trimFunction != null;
        if (trim) {
            buf.append(this.trimFunction).append('(');
        }
        buf.append(dbAttribute.getName());
        if (trim) {
            buf.append(')');
        }
    }

    public void setAdapter(DbAdapter adapter) {
        this.adapter = adapter;
    }

    public DbAdapter getAdapter() {
        return this.adapter;
    }

    public String getTrimFunction() {
        return this.trimFunction;
    }

    public void setTrimFunction(String string) {
        this.trimFunction = string;
    }

    public void bindParameters(PreparedStatement statement, BatchQuery query, List dbAttributes) throws SQLException, Exception {
        this.bindParameters(statement, query);
    }

    public void bindParameters(PreparedStatement statement, BatchQuery query) throws SQLException, Exception {
        List dbAttributes = query.getDbAttributes();
        int attributeCount = dbAttributes.size();
        for (int i = 0; i < attributeCount; ++i) {
            Object value = query.getValue(i);
            DbAttribute attribute = (DbAttribute)dbAttributes.get(i);
            this.adapter.bindParameter(statement, value, i + 1, attribute.getType(), attribute.getPrecision());
        }
    }

    public List getParameterValues(BatchQuery query) {
        List attributes = query.getDbAttributes();
        int len = attributes.size();
        ArrayList<Object> values = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            values.add(query.getValue(i));
        }
        return values;
    }
}

