/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access.types;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.objectstyle.cayenne.CayenneException;
import org.objectstyle.cayenne.access.types.AbstractType;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.validation.BeanValidationFailure;
import org.objectstyle.cayenne.validation.ValidationResult;

public class CharType
extends AbstractType {
    private static final int BUF_SIZE = 8192;
    protected boolean trimmingChars;
    protected boolean usingClobs;

    public CharType(boolean trimingChars, boolean usingClobs) {
        this.trimmingChars = trimingChars;
        this.usingClobs = usingClobs;
    }

    public String getClassName() {
        return String.class.getName();
    }

    public boolean validateProperty(Object source, String property, Object value, DbAttribute dbAttribute, ValidationResult validationResult) {
        if (!(value instanceof String)) {
            return true;
        }
        if (dbAttribute.getMaxLength() <= 0) {
            return true;
        }
        String string = (String)value;
        if (string.length() > dbAttribute.getMaxLength()) {
            String message = "\"" + property + "\" exceeds maximum allowed length (" + dbAttribute.getMaxLength() + " chars): " + string.length();
            validationResult.addFailure(new BeanValidationFailure(source, property, message));
            return false;
        }
        return true;
    }

    public Object materializeObject(ResultSet rs, int index, int type) throws Exception {
        String val = null;
        if (type == 2005) {
            val = this.isUsingClobs() ? this.readClob(rs.getClob(index)) : this.readCharStream(rs, index);
        } else {
            val = rs.getString(index);
            if (val != null && type == 1 && this.isTrimmingChars()) {
                val = val.trim();
            }
        }
        return val;
    }

    public Object materializeObject(CallableStatement cs, int index, int type) throws Exception {
        String val = null;
        if (type == 2005) {
            if (!this.isUsingClobs()) {
                throw new CayenneException("Character streams are not supported in stored procedure parameters.");
            }
            val = this.readClob(cs.getClob(index));
        } else {
            val = cs.getString(index);
            if (val != null && type == 1 && this.isTrimmingChars()) {
                val = val.trim();
            }
        }
        return val;
    }

    public void setJdbcObject(PreparedStatement st, Object val, int pos, int type, int precision) throws Exception {
        if (type == 2005) {
            st.setString(pos, (String)val);
        } else {
            super.setJdbcObject(st, val, pos, type, precision);
        }
    }

    protected String readClob(Clob clob) throws IOException, SQLException {
        if (clob == null) {
            return null;
        }
        if (clob.length() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("CLOB is too big to be read as String in memory: " + clob.length());
        }
        int size = (int)clob.length();
        if (size == 0) {
            return "";
        }
        int bufSize = size < 8192 ? size : 8192;
        Reader in = clob.getCharacterStream();
        return in != null ? this.readValueStream(new BufferedReader(in, bufSize), size, bufSize) : null;
    }

    protected String readCharStream(ResultSet rs, int index) throws IOException, SQLException {
        Reader in = rs.getCharacterStream(index);
        return in != null ? this.readValueStream(in, -1, 8192) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readValueStream(Reader in, int streamSize, int bufSize) throws IOException {
        char[] buf = new char[bufSize];
        StringWriter out = streamSize > 0 ? new StringWriter(streamSize) : new StringWriter();
        try {
            int read;
            while ((read = in.read(buf, 0, bufSize)) >= 0) {
                out.write(buf, 0, read);
            }
            String string = out.toString();
            return string;
        }
        finally {
            in.close();
        }
    }

    public boolean isTrimmingChars() {
        return this.trimmingChars;
    }

    public void setTrimmingChars(boolean trimingChars) {
        this.trimmingChars = trimingChars;
    }

    public boolean isUsingClobs() {
        return this.usingClobs;
    }

    public void setUsingClobs(boolean usingClobs) {
        this.usingClobs = usingClobs;
    }
}

