/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.conf;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.objectstyle.cayenne.access.QueryLogger;
import org.objectstyle.cayenne.conf.Configuration;
import org.objectstyle.cayenne.conf.DataSourceFactory;
import org.objectstyle.cayenne.util.Util;

public class JNDIDataSourceFactory
implements DataSourceFactory {
    private static final Logger logObj = Logger.getLogger(JNDIDataSourceFactory.class);
    protected Configuration parentConfig;

    public void initializeWithParentConfiguration(Configuration conf) {
        this.parentConfig = conf;
    }

    public DataSource getDataSource(String location, Level logLevel) throws Exception {
        return this.getDataSource(location);
    }

    public DataSource getDataSource(String location) throws Exception {
        try {
            return this.loadViaJNDI(location);
        }
        catch (Exception ex) {
            logObj.info("failed JNDI lookup, attempt to load from local preferences. Location key:" + location);
            try {
                return this.loadFromPreferences(location);
            }
            catch (Exception preferencesException) {
                logObj.info("failed loading from local preferences", Util.unwindException(preferencesException));
                QueryLogger.logConnectFailure(ex);
                throw ex;
            }
        }
    }

    DataSource loadViaJNDI(String location) throws NamingException {
        DataSource ds;
        QueryLogger.logConnect(location);
        InitialContext initCtx = new InitialContext();
        try {
            Context envCtx = (Context)initCtx.lookup("java:comp/env");
            ds = (DataSource)envCtx.lookup(location);
        }
        catch (NamingException namingEx) {
            ds = (DataSource)initCtx.lookup(location);
        }
        QueryLogger.logConnectSuccess();
        return ds;
    }

    DataSource loadFromPreferences(String location) throws Exception {
        DataSourceFactory prefsFactory = (DataSourceFactory)Class.forName("org.objectstyle.cayenne.modeler.pref.PreferencesDataSourceFactory").newInstance();
        prefsFactory.initializeWithParentConfiguration(this.parentConfig);
        return prefsFactory.getDataSource(location);
    }
}

