/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dataview;

import javax.swing.AbstractListModel;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.dataview.DataObjectChangeEvent;
import org.objectstyle.cayenne.dataview.DataObjectChangeListener;
import org.objectstyle.cayenne.dataview.DataObjectList;
import org.objectstyle.cayenne.dataview.FieldValueChangeEvent;
import org.objectstyle.cayenne.dataview.FieldValueChangeListener;
import org.objectstyle.cayenne.dataview.ObjEntityViewField;

public class DOListModel
extends AbstractListModel
implements DataObjectChangeListener,
FieldValueChangeListener {
    protected ObjEntityViewField viewField;
    protected DataObjectList dataObjects = new DataObjectList(1);

    public void setViewField(ObjEntityViewField field) {
        if (this.viewField != null) {
            this.viewField.getOwner().getOwner().removeFieldValueChangeListener(this);
        }
        this.viewField = field;
        this.viewField.getOwner().getOwner().addFieldValueChangeListener(this);
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public void setDataObjects(DataObjectList dataObjects) {
        this.dataObjects.removeDataObjectChangeListener(this);
        this.dataObjects = dataObjects;
        this.dataObjects.addDataObjectChangeListener(this);
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public int getSize() {
        return this.dataObjects.size();
    }

    public DataObject getDataObject(int index) {
        return (DataObject)this.dataObjects.get(index);
    }

    public Object getElementAt(int index) {
        if (this.viewField == null) {
            return this.getDataObject(index);
        }
        return this.viewField.getValue(this.getDataObject(index));
    }

    public void dataChanged(DataObjectChangeEvent event) {
        if (event.isMultiObjectChange()) {
            this.fireContentsChanged(this, 0, this.getSize());
            return;
        }
        int affectedRow = event.getAffectedDataObjectIndex();
        switch (event.getId()) {
            case 1: {
                this.fireIntervalAdded(this, affectedRow, affectedRow);
                break;
            }
            case 2: {
                this.fireIntervalRemoved(this, affectedRow, affectedRow);
                break;
            }
            case 3: {
                this.fireContentsChanged(this, affectedRow, affectedRow);
                break;
            }
            default: {
                this.fireContentsChanged(this, 0, this.getSize());
            }
        }
    }

    public ObjEntityViewField getViewField() {
        return this.viewField;
    }

    public DataObjectList getDataObjects() {
        return this.dataObjects;
    }

    public void fieldValueChanged(FieldValueChangeEvent event) {
        int index;
        if (this.viewField != null && this.viewField.isSameObjAttribute(event.getField()) && (index = this.dataObjects.indexOf(event.getModifiedObject())) >= 0) {
            this.fireContentsChanged(this, index, index);
        }
    }
}

