/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dataview;

import javax.swing.table.AbstractTableModel;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.dataview.DataObjectChangeEvent;
import org.objectstyle.cayenne.dataview.DataObjectChangeListener;
import org.objectstyle.cayenne.dataview.DataObjectList;
import org.objectstyle.cayenne.dataview.ObjEntityView;
import org.objectstyle.cayenne.dataview.ObjEntityViewField;

public class DOTableModel
extends AbstractTableModel
implements DataObjectChangeListener {
    private ObjEntityView view;
    private int[] columnMap;
    private String[] columnNames;
    private boolean[] editableColumns;
    private Class[] columnClasses;
    private int columnCount = 0;
    private DataObjectList dataObjects = new DataObjectList(1);
    static /* synthetic */ Class class$java$lang$String;

    public DOTableModel() {
        this.updateModel();
    }

    public ObjEntityView getView() {
        return this.view;
    }

    public void setView(ObjEntityView view) {
        this.view = view;
        this.updateModel();
    }

    public void updateModel() {
        if (this.view != null) {
            int fieldCount = this.view.getFieldCount();
            this.columnMap = new int[fieldCount];
            this.columnNames = new String[fieldCount];
            this.editableColumns = new boolean[fieldCount];
            this.columnClasses = new Class[fieldCount];
            this.columnCount = 0;
            for (int i = 0; i < fieldCount; ++i) {
                ObjEntityViewField field = this.view.getField(i);
                if (!field.isVisible()) continue;
                this.columnMap[this.columnCount] = i;
                this.columnNames[this.columnCount] = field.getCaption();
                this.editableColumns[this.columnCount] = field.isEditable();
                this.columnClasses[this.columnCount] = field.getJavaClass();
                if (this.columnClasses[this.columnCount] == null) {
                    this.columnClasses[this.columnCount] = class$java$lang$String == null ? DOTableModel.class$("java.lang.String") : class$java$lang$String;
                }
                ++this.columnCount;
            }
        } else {
            this.columnMap = new int[0];
            this.columnNames = new String[0];
            this.editableColumns = new boolean[0];
            this.columnClasses = new Class[0];
            this.columnCount = 0;
            this.dataObjects = new DataObjectList(1);
        }
        this.fireTableStructureChanged();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.editableColumns[columnIndex];
    }

    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public Class getColumnClass(int columnIndex) {
        return this.columnClasses[columnIndex];
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        ObjEntityViewField field = this.getField(columnIndex);
        DataObject obj = this.getDataObject(rowIndex);
        Object value = field.getValue(obj);
        return value;
    }

    public int getRowCount() {
        return this.dataObjects.size();
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        ObjEntityViewField field = this.getField(columnIndex);
        DataObject obj = this.getDataObject(rowIndex);
        field.setValue(obj, value);
    }

    public DataObject getDataObject(int rowIndex) {
        return this.dataObjects.getDataObject(rowIndex);
    }

    public ObjEntityViewField getField(int columnIndex) {
        return this.view.getField(this.columnMap[columnIndex]);
    }

    public DataObjectList getDataObjects() {
        return this.dataObjects;
    }

    public void setDataObjects(DataObjectList dataObjects) {
        this.dataObjects.removeDataObjectChangeListener(this);
        this.dataObjects = dataObjects;
        this.dataObjects.addDataObjectChangeListener(this);
        this.fireTableDataChanged();
    }

    public void dataChanged(DataObjectChangeEvent event) {
        if (event.isMultiObjectChange()) {
            this.fireTableDataChanged();
            return;
        }
        int affectedRow = event.getAffectedDataObjectIndex();
        switch (event.getId()) {
            case 1: {
                this.fireTableRowsInserted(affectedRow, affectedRow);
                break;
            }
            case 2: {
                this.fireTableRowsDeleted(affectedRow, affectedRow);
                break;
            }
            case 3: {
                this.fireTableRowsUpdated(affectedRow, affectedRow);
                break;
            }
            default: {
                this.fireTableDataChanged();
            }
        }
    }
}

