/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dba;

import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.access.DataNode;
import org.objectstyle.cayenne.access.OperationObserver;
import org.objectstyle.cayenne.access.QueryTranslator;
import org.objectstyle.cayenne.access.trans.DeleteTranslator;
import org.objectstyle.cayenne.access.trans.InsertTranslator;
import org.objectstyle.cayenne.access.trans.ProcedureTranslator;
import org.objectstyle.cayenne.access.trans.QualifierTranslator;
import org.objectstyle.cayenne.access.trans.QueryAssembler;
import org.objectstyle.cayenne.access.trans.SelectTranslator;
import org.objectstyle.cayenne.access.trans.UpdateTranslator;
import org.objectstyle.cayenne.access.types.BooleanType;
import org.objectstyle.cayenne.access.types.ByteArrayType;
import org.objectstyle.cayenne.access.types.CharType;
import org.objectstyle.cayenne.access.types.ExtendedType;
import org.objectstyle.cayenne.access.types.ExtendedTypeMap;
import org.objectstyle.cayenne.access.types.UtilDateType;
import org.objectstyle.cayenne.dba.DbAdapter;
import org.objectstyle.cayenne.dba.JdbcActionBuilder;
import org.objectstyle.cayenne.dba.JdbcPkGenerator;
import org.objectstyle.cayenne.dba.PkGenerator;
import org.objectstyle.cayenne.dba.TypesHandler;
import org.objectstyle.cayenne.dba.TypesMapping;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.DbJoin;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.map.DerivedDbEntity;
import org.objectstyle.cayenne.query.BatchQuery;
import org.objectstyle.cayenne.query.DeleteQuery;
import org.objectstyle.cayenne.query.InsertQuery;
import org.objectstyle.cayenne.query.ProcedureQuery;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.SQLAction;
import org.objectstyle.cayenne.query.SelectQuery;
import org.objectstyle.cayenne.query.UpdateQuery;
import org.objectstyle.cayenne.util.ResourceLocator;
import org.objectstyle.cayenne.util.Util;

public class JdbcAdapter
implements DbAdapter {
    protected PkGenerator pkGenerator;
    protected TypesHandler typesHandler;
    protected ExtendedTypeMap extendedTypes;
    protected boolean supportsBatchUpdates;
    protected boolean supportsFkConstraints;
    protected boolean supportsUniqueConstraints;
    protected boolean supportsGeneratedKeys;
    static /* synthetic */ Class class$org$objectstyle$cayenne$dba$JdbcAdapter;

    public JdbcAdapter() {
        this.setSupportsBatchUpdates(false);
        this.setSupportsUniqueConstraints(true);
        this.setSupportsFkConstraints(true);
        this.pkGenerator = this.createPkGenerator();
        this.typesHandler = TypesHandler.getHandler(this.findAdapterResource("/types.xml"));
        this.extendedTypes = new ExtendedTypeMap();
        this.configureExtendedTypes(this.extendedTypes);
    }

    public String getBatchTerminator() {
        return ";";
    }

    public URL findAdapterResource(String name) {
        for (Class<?> adapterClass = this.getClass(); adapterClass != null && (class$org$objectstyle$cayenne$dba$JdbcAdapter == null ? JdbcAdapter.class$("org.objectstyle.cayenne.dba.JdbcAdapter") : class$org$objectstyle$cayenne$dba$JdbcAdapter).isAssignableFrom(adapterClass); adapterClass = adapterClass.getSuperclass()) {
            String path = Util.getPackagePath(adapterClass.getName()) + name;
            URL url = ResourceLocator.findURLInClasspath(path);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    protected void configureExtendedTypes(ExtendedTypeMap map) {
        map.registerType(new BooleanType());
        map.registerType(new CharType(false, true));
        map.registerType(new UtilDateType());
        map.registerType(new ByteArrayType(false, true));
    }

    protected PkGenerator createPkGenerator() {
        return new JdbcPkGenerator();
    }

    public PkGenerator getPkGenerator() {
        return this.pkGenerator;
    }

    public void setPkGenerator(PkGenerator pkGenerator) {
        this.pkGenerator = pkGenerator;
    }

    public QueryTranslator getQueryTranslator(Query query) throws Exception {
        Class queryClass = this.queryTranslatorClass(query);
        try {
            QueryTranslator t = (QueryTranslator)queryClass.newInstance();
            t.setQuery(query);
            t.setAdapter(this);
            return t;
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Can't load translator class: " + queryClass);
        }
    }

    protected Class queryTranslatorClass(Query q) {
        if (q == null) {
            throw new NullPointerException("Null query.");
        }
        if (q instanceof SelectQuery) {
            return SelectTranslator.class;
        }
        if (q instanceof UpdateQuery) {
            return UpdateTranslator.class;
        }
        if (q instanceof InsertQuery) {
            return InsertTranslator.class;
        }
        if (q instanceof DeleteQuery) {
            return DeleteTranslator.class;
        }
        if (q instanceof ProcedureQuery) {
            return ProcedureTranslator.class;
        }
        throw new CayenneRuntimeException("Unrecognized query class..." + q.getClass().getName());
    }

    public boolean supportsFkConstraints() {
        return this.supportsFkConstraints;
    }

    public void setSupportsFkConstraints(boolean flag) {
        this.supportsFkConstraints = flag;
    }

    public boolean supportsUniqueConstraints() {
        return this.supportsUniqueConstraints;
    }

    public void setSupportsUniqueConstraints(boolean flag) {
        this.supportsUniqueConstraints = flag;
    }

    public String dropTable(DbEntity ent) {
        return "DROP TABLE " + ent.getFullyQualifiedName();
    }

    public String createTable(DbEntity entity) {
        if (entity instanceof DerivedDbEntity) {
            throw new CayenneRuntimeException("Can't create table for derived DbEntity '" + entity.getName() + "'.");
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("CREATE TABLE ").append(entity.getFullyQualifiedName()).append(" (");
        Iterator it = entity.getAttributes().iterator();
        if (it.hasNext()) {
            boolean first = true;
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    sqlBuffer.append(", ");
                }
                DbAttribute column = (DbAttribute)it.next();
                if (column.getType() == Integer.MAX_VALUE) {
                    throw new CayenneRuntimeException("Undefined type for attribute '" + entity.getFullyQualifiedName() + "." + column.getName() + "'.");
                }
                this.createTableAppendColumn(sqlBuffer, column);
            }
            this.createTableAppendPKClause(sqlBuffer, entity);
        }
        sqlBuffer.append(')');
        return sqlBuffer.toString();
    }

    protected void createTableAppendPKClause(StringBuffer sqlBuffer, DbEntity entity) {
        Iterator pkit = entity.getPrimaryKey().iterator();
        if (pkit.hasNext()) {
            sqlBuffer.append(", PRIMARY KEY (");
            boolean firstPk = true;
            while (pkit.hasNext()) {
                if (firstPk) {
                    firstPk = false;
                } else {
                    sqlBuffer.append(", ");
                }
                DbAttribute at = (DbAttribute)pkit.next();
                sqlBuffer.append(at.getName());
            }
            sqlBuffer.append(')');
        }
    }

    protected void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        String[] types = this.externalTypesForJdbcType(column.getType());
        if (types == null || types.length == 0) {
            String entityName = column.getEntity() != null ? ((DbEntity)column.getEntity()).getFullyQualifiedName() : "<null>";
            throw new CayenneRuntimeException("Undefined type for attribute '" + entityName + "." + column.getName() + "': " + column.getType());
        }
        String type = types[0];
        sqlBuffer.append(column.getName()).append(' ').append(type);
        if (TypesMapping.supportsLength(column.getType())) {
            int prec;
            int len = column.getMaxLength();
            int n = prec = TypesMapping.isDecimal(column.getType()) ? column.getPrecision() : -1;
            if (prec > len) {
                prec = -1;
            }
            if (len > 0) {
                sqlBuffer.append('(').append(len);
                if (prec >= 0) {
                    sqlBuffer.append(", ").append(prec);
                }
                sqlBuffer.append(')');
            }
        }
        sqlBuffer.append(column.isMandatory() ? " NOT NULL" : " NULL");
    }

    public String createUniqueConstraint(DbEntity source, Collection columns) {
        if (columns == null || columns.isEmpty()) {
            throw new CayenneRuntimeException("Can't create UNIQUE constraint - no columns specified.");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("ALTER TABLE ").append(source.getFullyQualifiedName()).append(" ADD UNIQUE (");
        Iterator it = columns.iterator();
        DbAttribute first = (DbAttribute)it.next();
        buf.append(first.getName());
        while (it.hasNext()) {
            DbAttribute next = (DbAttribute)it.next();
            buf.append(", ");
            buf.append(next.getName());
        }
        buf.append(")");
        return buf.toString();
    }

    public String createFkConstraint(DbRelationship rel) {
        StringBuffer buf = new StringBuffer();
        StringBuffer refBuf = new StringBuffer();
        buf.append("ALTER TABLE ").append(((DbEntity)rel.getSourceEntity()).getFullyQualifiedName()).append(" ADD FOREIGN KEY (");
        Iterator jit = rel.getJoins().iterator();
        boolean first = true;
        while (jit.hasNext()) {
            DbJoin join = (DbJoin)jit.next();
            if (!first) {
                buf.append(", ");
                refBuf.append(", ");
            } else {
                first = false;
            }
            buf.append(join.getSourceName());
            refBuf.append(join.getTargetName());
        }
        buf.append(") REFERENCES ").append(((DbEntity)rel.getTargetEntity()).getFullyQualifiedName()).append(" (").append(refBuf.toString()).append(')');
        return buf.toString();
    }

    public String[] externalTypesForJdbcType(int type) {
        return this.typesHandler.externalTypesForJdbcType(type);
    }

    public ExtendedTypeMap getExtendedTypes() {
        return this.extendedTypes;
    }

    public DbAttribute buildAttribute(String name, String typeName, int type, int size, int precision, boolean allowNulls) {
        DbAttribute attr = new DbAttribute();
        attr.setName(name);
        attr.setType(type);
        attr.setMandatory(!allowNulls);
        if (size >= 0) {
            attr.setMaxLength(size);
        }
        if (precision >= 0) {
            attr.setPrecision(precision);
        }
        return attr;
    }

    public String tableTypeForTable() {
        return "TABLE";
    }

    public String tableTypeForView() {
        return "VIEW";
    }

    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        return new QualifierTranslator(queryAssembler);
    }

    public DataNode createDataNode(String name) {
        DataNode node = new DataNode(name);
        node.setAdapter(this);
        return node;
    }

    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new JdbcActionBuilder(this, node.getEntityResolver()));
    }

    public void bindParameter(PreparedStatement statement, Object object, int pos, int sqlType, int precision) throws SQLException, Exception {
        if (object == null) {
            statement.setNull(pos, sqlType);
        } else {
            ExtendedType typeProcessor = this.getExtendedTypes().getRegisteredType(object.getClass());
            typeProcessor.setJdbcObject(statement, object, pos, sqlType, precision);
        }
    }

    public boolean supportsBatchUpdates() {
        return this.supportsBatchUpdates;
    }

    public void setSupportsBatchUpdates(boolean flag) {
        this.supportsBatchUpdates = flag;
    }

    public boolean supportsGeneratedKeys() {
        return this.supportsGeneratedKeys;
    }

    public void setSupportsGeneratedKeys(boolean flag) {
        this.supportsGeneratedKeys = flag;
    }

    public boolean shouldRunBatchQuery(DataNode node, Connection con, BatchQuery query, OperationObserver delegate) throws SQLException, Exception {
        return true;
    }
}

