/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dba;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypesMapping {
    public static final int NOT_DEFINED = Integer.MAX_VALUE;
    public static final String SQL_ARRAY = "ARRAY";
    public static final String SQL_BIGINT = "BIGINT";
    public static final String SQL_BINARY = "BINARY";
    public static final String SQL_BIT = "BIT";
    public static final String SQL_BLOB = "BLOB";
    public static final String SQL_BOOLEAN = "BOOLEAN";
    public static final String SQL_CLOB = "CLOB";
    public static final String SQL_CHAR = "CHAR";
    public static final String SQL_DATE = "DATE";
    public static final String SQL_DECIMAL = "DECIMAL";
    public static final String SQL_DOUBLE = "DOUBLE";
    public static final String SQL_FLOAT = "FLOAT";
    public static final String SQL_INTEGER = "INTEGER";
    public static final String SQL_LONGVARCHAR = "LONGVARCHAR";
    public static final String SQL_LONGVARBINARY = "LONGVARBINARY";
    public static final String SQL_NUMERIC = "NUMERIC";
    public static final String SQL_REAL = "REAL";
    public static final String SQL_SMALLINT = "SMALLINT";
    public static final String SQL_TINYINT = "TINYINT";
    public static final String SQL_TIME = "TIME";
    public static final String SQL_TIMESTAMP = "TIMESTAMP";
    public static final String SQL_VARBINARY = "VARBINARY";
    public static final String SQL_VARCHAR = "VARCHAR";
    public static final String SQL_OTHER = "OTHER";
    public static final String JAVA_LONG = "java.lang.Long";
    public static final String JAVA_BYTES = "byte[]";
    public static final String JAVA_BOOLEAN = "java.lang.Boolean";
    public static final String JAVA_STRING = "java.lang.String";
    public static final String JAVA_SQLDATE = "java.sql.Date";
    public static final String JAVA_UTILDATE = "java.util.Date";
    public static final String JAVA_BIGDECIMAL = "java.math.BigDecimal";
    public static final String JAVA_DOUBLE = "java.lang.Double";
    public static final String JAVA_FLOAT = "java.lang.Float";
    public static final String JAVA_INTEGER = "java.lang.Integer";
    public static final String JAVA_SHORT = "java.lang.Short";
    public static final String JAVA_BYTE = "java.lang.Byte";
    public static final String JAVA_TIME = "java.sql.Time";
    public static final String JAVA_TIMESTAMP = "java.sql.Timestamp";
    private static final Map sqlStringType = new HashMap();
    private static final Map sqlEnumType = new HashMap();
    private static final Map sqlEnumJava = new HashMap();
    private static final Map javaSqlEnum = new HashMap();
    protected Map databaseTypes = new HashMap();

    public static boolean supportsLength(int type) {
        return type == -2 || type == 1 || type == 3 || type == 8 || type == 6 || type == 2 || type == 7 || type == -3 || type == 12;
    }

    public static boolean isNumeric(int type) {
        return type == -5 || type == -7 || type == 3 || type == 8 || type == 6 || type == 4 || type == 2 || type == 7 || type == 5 || type == -6;
    }

    public static boolean isDecimal(int type) {
        return type == 3 || type == 8 || type == 6 || type == 7 || type == 2;
    }

    public static String[] getDatabaseTypes() {
        Set keys = sqlStringType.keySet();
        int len = keys.size();
        String[] types = new String[len];
        Iterator it = keys.iterator();
        for (int i = 0; i < len; ++i) {
            types[i] = (String)it.next();
        }
        return types;
    }

    protected static String pickDataType(int jdbcType, TypeInfo[] alts) {
        String uppercase;
        int i;
        int len = alts.length;
        if (len == 0) {
            return null;
        }
        if (len == 1) {
            return alts[0].name;
        }
        String jdbcName = TypesMapping.getSqlNameByType(jdbcType).toUpperCase();
        for (int i2 = 0; i2 < len; ++i2) {
            if (!jdbcName.equalsIgnoreCase(alts[i2].name)) continue;
            return alts[i2].name;
        }
        long maxPrec = 0L;
        for (int i3 = 0; i3 < len; ++i3) {
            if (maxPrec >= alts[i3].precision) continue;
            maxPrec = alts[i3].precision;
        }
        ArrayList<TypeInfo> list = new ArrayList<TypeInfo>();
        for (int i4 = 0; i4 < len; ++i4) {
            if (maxPrec != alts[i4].precision) continue;
            list.add(alts[i4]);
        }
        int slen = list.size();
        if (slen == 1) {
            return ((TypeInfo)list.get((int)0)).name;
        }
        for (i = 0; i < slen; ++i) {
            uppercase = ((TypeInfo)list.get((int)i)).name.toUpperCase();
            if (!uppercase.startsWith(jdbcName) && !uppercase.endsWith(jdbcName)) continue;
            return ((TypeInfo)list.get((int)i)).name;
        }
        for (i = 0; i < slen; ++i) {
            uppercase = ((TypeInfo)list.get((int)i)).name.toUpperCase();
            if (uppercase.indexOf(jdbcName) < 0) continue;
            return ((TypeInfo)list.get((int)i)).name;
        }
        return ((TypeInfo)list.get((int)0)).name;
    }

    public static int getSqlTypeByName(String typeName) {
        Integer tmp = (Integer)sqlStringType.get(typeName);
        return null == tmp ? Integer.MAX_VALUE : tmp;
    }

    public static String getSqlNameByType(int type) {
        return (String)sqlEnumType.get(new Integer(type));
    }

    public static int getSqlTypeByJava(String javaTypeName) {
        Integer temp = (Integer)javaSqlEnum.get(javaTypeName);
        return null == temp ? Integer.MAX_VALUE : temp;
    }

    public static int getSqlTypeByJava(Class javaClass) {
        while (javaClass != null) {
            String name = javaClass.isArray() ? javaClass.getComponentType().getName() + "[]" : javaClass.getName();
            Object type = javaSqlEnum.get(name);
            if (type != null) {
                return ((Number)type).intValue();
            }
            javaClass = javaClass.getSuperclass();
        }
        return Integer.MAX_VALUE;
    }

    public static String getJavaBySqlType(int type) {
        return (String)sqlEnumJava.get(new Integer(type));
    }

    public static String getJavaBySqlType(int type, int length, int precision) {
        if (type == 2 && precision == 0) {
            type = 4;
        }
        return (String)sqlEnumJava.get(new Integer(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypesMapping(DatabaseMetaData metaData) throws SQLException {
        ResultSet rs = metaData.getTypeInfo();
        try {
            while (rs.next()) {
                TypeInfo info = new TypeInfo();
                info.name = rs.getString("TYPE_NAME");
                info.jdbcType = rs.getInt("DATA_TYPE");
                info.precision = rs.getLong("PRECISION");
                Integer key = new Integer(info.jdbcType);
                ArrayList<TypeInfo> infos = (ArrayList<TypeInfo>)this.databaseTypes.get(key);
                if (infos == null) {
                    infos = new ArrayList<TypeInfo>();
                    this.databaseTypes.put(key, infos);
                }
                infos.add(info);
            }
        }
        finally {
            rs.close();
        }
        Integer ts = new Integer(93);
        Integer dt = new Integer(91);
        List tsInfo = (List)this.databaseTypes.get(ts);
        List dtInfo = (List)this.databaseTypes.get(dt);
        if (tsInfo != null && dtInfo == null) {
            this.databaseTypes.put(dt, tsInfo);
        }
        if (dtInfo != null && tsInfo == null) {
            this.databaseTypes.put(ts, dtInfo);
        }
        Integer clob = new Integer(2005);
        Integer lvc = new Integer(-1);
        List clobInfo = (List)this.databaseTypes.get(clob);
        List lvcInfo = (List)this.databaseTypes.get(lvc);
        if (clobInfo != null && lvcInfo == null) {
            this.databaseTypes.put(lvc, clobInfo);
        }
        if (lvcInfo != null && clobInfo == null) {
            this.databaseTypes.put(clob, lvcInfo);
        }
        Integer blob = new Integer(2004);
        Integer lvb = new Integer(-4);
        List blobInfo = (List)this.databaseTypes.get(blob);
        List lvbInfo = (List)this.databaseTypes.get(lvb);
        if (blobInfo != null && lvbInfo == null) {
            this.databaseTypes.put(lvb, blobInfo);
        }
        if (lvbInfo != null && blobInfo == null) {
            this.databaseTypes.put(blob, lvbInfo);
        }
    }

    static {
        sqlStringType.put(SQL_ARRAY, new Integer(2003));
        sqlStringType.put(SQL_BIGINT, new Integer(-5));
        sqlStringType.put(SQL_BINARY, new Integer(-2));
        sqlStringType.put(SQL_BIT, new Integer(-7));
        sqlStringType.put(SQL_BLOB, new Integer(2004));
        sqlStringType.put(SQL_BOOLEAN, new Integer(16));
        sqlStringType.put(SQL_CLOB, new Integer(2005));
        sqlStringType.put(SQL_CHAR, new Integer(1));
        sqlStringType.put(SQL_DATE, new Integer(91));
        sqlStringType.put(SQL_DECIMAL, new Integer(3));
        sqlStringType.put(SQL_DOUBLE, new Integer(8));
        sqlStringType.put(SQL_FLOAT, new Integer(6));
        sqlStringType.put(SQL_INTEGER, new Integer(4));
        sqlStringType.put(SQL_LONGVARCHAR, new Integer(-1));
        sqlStringType.put(SQL_LONGVARBINARY, new Integer(-4));
        sqlStringType.put(SQL_NUMERIC, new Integer(2));
        sqlStringType.put(SQL_REAL, new Integer(7));
        sqlStringType.put(SQL_SMALLINT, new Integer(5));
        sqlStringType.put(SQL_TINYINT, new Integer(-6));
        sqlStringType.put(SQL_TIME, new Integer(92));
        sqlStringType.put(SQL_TIMESTAMP, new Integer(93));
        sqlStringType.put(SQL_VARBINARY, new Integer(-3));
        sqlStringType.put(SQL_VARCHAR, new Integer(12));
        sqlStringType.put(SQL_OTHER, new Integer(1111));
        sqlEnumType.put(new Integer(2003), SQL_ARRAY);
        sqlEnumType.put(new Integer(-5), SQL_BIGINT);
        sqlEnumType.put(new Integer(-2), SQL_BINARY);
        sqlEnumType.put(new Integer(-7), SQL_BIT);
        sqlEnumType.put(new Integer(16), SQL_BOOLEAN);
        sqlEnumType.put(new Integer(2004), SQL_BLOB);
        sqlEnumType.put(new Integer(2005), SQL_CLOB);
        sqlEnumType.put(new Integer(1), SQL_CHAR);
        sqlEnumType.put(new Integer(91), SQL_DATE);
        sqlEnumType.put(new Integer(3), SQL_DECIMAL);
        sqlEnumType.put(new Integer(8), SQL_DOUBLE);
        sqlEnumType.put(new Integer(6), SQL_FLOAT);
        sqlEnumType.put(new Integer(4), SQL_INTEGER);
        sqlEnumType.put(new Integer(-1), SQL_LONGVARCHAR);
        sqlEnumType.put(new Integer(-4), SQL_LONGVARBINARY);
        sqlEnumType.put(new Integer(2), SQL_NUMERIC);
        sqlEnumType.put(new Integer(7), SQL_REAL);
        sqlEnumType.put(new Integer(5), SQL_SMALLINT);
        sqlEnumType.put(new Integer(-6), SQL_TINYINT);
        sqlEnumType.put(new Integer(92), SQL_TIME);
        sqlEnumType.put(new Integer(93), SQL_TIMESTAMP);
        sqlEnumType.put(new Integer(-3), SQL_VARBINARY);
        sqlEnumType.put(new Integer(12), SQL_VARCHAR);
        sqlEnumType.put(new Integer(1111), SQL_OTHER);
        sqlEnumJava.put(new Integer(-5), JAVA_LONG);
        sqlEnumJava.put(new Integer(-2), JAVA_BYTES);
        sqlEnumJava.put(new Integer(-7), JAVA_BOOLEAN);
        sqlEnumJava.put(new Integer(16), JAVA_BOOLEAN);
        sqlEnumJava.put(new Integer(2004), JAVA_BYTES);
        sqlEnumJava.put(new Integer(2005), JAVA_STRING);
        sqlEnumJava.put(new Integer(1), JAVA_STRING);
        sqlEnumJava.put(new Integer(91), JAVA_UTILDATE);
        sqlEnumJava.put(new Integer(3), JAVA_BIGDECIMAL);
        sqlEnumJava.put(new Integer(8), JAVA_DOUBLE);
        sqlEnumJava.put(new Integer(6), JAVA_FLOAT);
        sqlEnumJava.put(new Integer(4), JAVA_INTEGER);
        sqlEnumJava.put(new Integer(-1), JAVA_STRING);
        sqlEnumJava.put(new Integer(-4), JAVA_BYTES);
        sqlEnumJava.put(new Integer(2), JAVA_BIGDECIMAL);
        sqlEnumJava.put(new Integer(7), JAVA_FLOAT);
        sqlEnumJava.put(new Integer(5), JAVA_SHORT);
        sqlEnumJava.put(new Integer(-6), JAVA_BYTE);
        sqlEnumJava.put(new Integer(92), JAVA_UTILDATE);
        sqlEnumJava.put(new Integer(93), JAVA_UTILDATE);
        sqlEnumJava.put(new Integer(-3), JAVA_BYTES);
        sqlEnumJava.put(new Integer(12), JAVA_STRING);
        javaSqlEnum.put(JAVA_LONG, new Integer(-5));
        javaSqlEnum.put(JAVA_BYTES, new Integer(-2));
        javaSqlEnum.put(JAVA_BOOLEAN, new Integer(-7));
        javaSqlEnum.put(JAVA_STRING, new Integer(12));
        javaSqlEnum.put(JAVA_SQLDATE, new Integer(91));
        javaSqlEnum.put(JAVA_TIMESTAMP, new Integer(93));
        javaSqlEnum.put(JAVA_BIGDECIMAL, new Integer(3));
        javaSqlEnum.put(JAVA_DOUBLE, new Integer(8));
        javaSqlEnum.put(JAVA_FLOAT, new Integer(6));
        javaSqlEnum.put(JAVA_INTEGER, new Integer(4));
        javaSqlEnum.put(JAVA_SHORT, new Integer(5));
        javaSqlEnum.put(JAVA_BYTE, new Integer(-6));
        javaSqlEnum.put(JAVA_TIME, new Integer(92));
        javaSqlEnum.put(JAVA_TIMESTAMP, new Integer(93));
    }

    static class TypeInfo {
        String name;
        int jdbcType;
        long precision;

        TypeInfo() {
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("[   TypeInfo: ").append(this.name);
            buf.append("\n    JDBC Type: ").append(TypesMapping.getSqlNameByType(this.jdbcType));
            buf.append("\n    Precision: ").append(this.precision);
            buf.append("\n]");
            return buf.toString();
        }
    }
}

