/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dba.db2;

import java.sql.PreparedStatement;
import java.util.Iterator;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.access.DataNode;
import org.objectstyle.cayenne.access.trans.QualifierTranslator;
import org.objectstyle.cayenne.access.trans.QueryAssembler;
import org.objectstyle.cayenne.access.types.BooleanType;
import org.objectstyle.cayenne.access.types.ByteArrayType;
import org.objectstyle.cayenne.access.types.CharType;
import org.objectstyle.cayenne.access.types.ExtendedTypeMap;
import org.objectstyle.cayenne.dba.JdbcAdapter;
import org.objectstyle.cayenne.dba.PkGenerator;
import org.objectstyle.cayenne.dba.TypesMapping;
import org.objectstyle.cayenne.dba.db2.DB2ActionBuilder;
import org.objectstyle.cayenne.dba.db2.DB2PkGenerator;
import org.objectstyle.cayenne.dba.db2.DB2QualifierTranslator;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.DerivedDbEntity;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.SQLAction;

public class DB2Adapter
extends JdbcAdapter {
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new DB2ActionBuilder(this, node.getEntityResolver()));
    }

    protected PkGenerator createPkGenerator() {
        return new DB2PkGenerator();
    }

    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new CharType(true, true));
        map.registerType(new DB2BooleanType());
        map.registerType(new ByteArrayType(false, false));
    }

    public String createTable(DbEntity ent) {
        if (ent instanceof DerivedDbEntity) {
            throw new CayenneRuntimeException("Can't create table for derived DbEntity '" + ent.getName() + "'.");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("CREATE TABLE ").append(ent.getFullyQualifiedName()).append(" (");
        Iterator it = ent.getAttributes().iterator();
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            DbAttribute at = (DbAttribute)it.next();
            if (at.getType() == Integer.MAX_VALUE) {
                throw new CayenneRuntimeException("Undefined type for attribute '" + ent.getFullyQualifiedName() + "." + at.getName() + "'.");
            }
            String[] types = this.externalTypesForJdbcType(at.getType());
            if (types == null || types.length == 0) {
                throw new CayenneRuntimeException("Undefined type for attribute '" + ent.getFullyQualifiedName() + "." + at.getName() + "': " + at.getType());
            }
            String type = types[0];
            buf.append(at.getName()).append(' ').append(type);
            if (TypesMapping.supportsLength(at.getType())) {
                int prec;
                int len = at.getMaxLength();
                int n = prec = TypesMapping.isDecimal(at.getType()) ? at.getPrecision() : -1;
                if (prec > len) {
                    prec = -1;
                }
                if (len > 0) {
                    buf.append('(').append(len);
                    if (prec >= 0) {
                        buf.append(", ").append(prec);
                    }
                    buf.append(')');
                }
            }
            if (!at.isMandatory()) continue;
            buf.append(" NOT NULL");
        }
        Iterator pkit = ent.getPrimaryKey().iterator();
        if (pkit.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append("PRIMARY KEY (");
            boolean firstPk = true;
            while (pkit.hasNext()) {
                if (firstPk) {
                    firstPk = false;
                } else {
                    buf.append(", ");
                }
                DbAttribute at = (DbAttribute)pkit.next();
                buf.append(at.getName());
            }
            buf.append(')');
        }
        buf.append(')');
        return buf.toString();
    }

    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        return new DB2QualifierTranslator(queryAssembler, "RTRIM");
    }

    final class DB2BooleanType
    extends BooleanType {
        DB2BooleanType() {
        }

        public void setJdbcObject(PreparedStatement st, Object val, int pos, int type, int precision) throws Exception {
            if (val != null) {
                st.setInt(pos, (Boolean)val != false ? 1 : 0);
            } else {
                st.setNull(pos, type);
            }
        }
    }
}

