/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dba.hsqldb;

import java.sql.Connection;
import org.objectstyle.cayenne.access.jdbc.ProcedureAction;
import org.objectstyle.cayenne.access.jdbc.SelectAction;
import org.objectstyle.cayenne.access.trans.ProcedureTranslator;
import org.objectstyle.cayenne.access.trans.SelectTranslator;
import org.objectstyle.cayenne.dba.DbAdapter;
import org.objectstyle.cayenne.dba.JdbcActionBuilder;
import org.objectstyle.cayenne.dba.hsqldb.HSQLDBProcedureTranslator;
import org.objectstyle.cayenne.dba.hsqldb.HSQLSelectTranslator;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.query.ProcedureQuery;
import org.objectstyle.cayenne.query.SQLAction;
import org.objectstyle.cayenne.query.SelectQuery;

class HSQLActionBuilder
extends JdbcActionBuilder {
    HSQLActionBuilder(DbAdapter adapter, EntityResolver resolver) {
        super(adapter, resolver);
    }

    public SQLAction objectSelectAction(SelectQuery query) {
        return new SelectAction(query, this.adapter, this.entityResolver){

            protected SelectTranslator createTranslator(Connection connection) {
                HSQLSelectTranslator translator = new HSQLSelectTranslator();
                translator.setQuery(this.query);
                translator.setAdapter(this.adapter);
                translator.setEntityResolver(this.getEntityResolver());
                translator.setConnection(connection);
                return translator;
            }
        };
    }

    public SQLAction procedureAction(ProcedureQuery query) {
        return new ProcedureAction(query, this.adapter, this.entityResolver){

            protected ProcedureTranslator createTranslator(Connection connection) {
                HSQLDBProcedureTranslator transl = new HSQLDBProcedureTranslator();
                transl.setAdapter(this.getAdapter());
                transl.setQuery(this.query);
                transl.setEntityResolver(this.getEntityResolver());
                transl.setConnection(connection);
                return transl;
            }
        };
    }
}

