/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dba.hsqldb;

import java.util.Collection;
import java.util.Iterator;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.access.DataNode;
import org.objectstyle.cayenne.dba.JdbcAdapter;
import org.objectstyle.cayenne.dba.hsqldb.HSQLActionBuilder;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.DbJoin;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.SQLAction;

public class HSQLDBAdapter
extends JdbcAdapter {
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new HSQLActionBuilder(this, node.getEntityResolver()));
    }

    public String createUniqueConstraint(DbEntity source, Collection columns) {
        if (columns == null || columns.isEmpty()) {
            throw new CayenneRuntimeException("Can't create UNIQUE constraint - no columns specified.");
        }
        String srcName = source.getName();
        StringBuffer buf = new StringBuffer();
        buf.append("ALTER TABLE ").append(srcName);
        buf.append(" ADD CONSTRAINT ");
        buf.append("U_");
        buf.append(srcName);
        buf.append("_");
        buf.append((long)((double)System.currentTimeMillis() / (Math.random() * 100000.0)));
        buf.append(" UNIQUE (");
        Iterator it = columns.iterator();
        DbAttribute first = (DbAttribute)it.next();
        buf.append(first.getName());
        while (it.hasNext()) {
            DbAttribute next = (DbAttribute)it.next();
            buf.append(", ");
            buf.append(next.getName());
        }
        buf.append(")");
        return buf.toString();
    }

    public String createFkConstraint(DbRelationship rel) {
        StringBuffer buf = new StringBuffer();
        StringBuffer refBuf = new StringBuffer();
        String srcName = ((DbEntity)rel.getSourceEntity()).getName();
        String dstName = ((DbEntity)rel.getTargetEntity()).getName();
        buf.append("ALTER TABLE ");
        buf.append(srcName);
        buf.append(" ADD CONSTRAINT ");
        buf.append("C_");
        buf.append(srcName);
        buf.append("_");
        buf.append((long)((double)System.currentTimeMillis() / (Math.random() * 100000.0)));
        buf.append(" FOREIGN KEY (");
        Iterator jit = rel.getJoins().iterator();
        boolean first = true;
        while (jit.hasNext()) {
            DbJoin join = (DbJoin)jit.next();
            if (!first) {
                buf.append(", ");
                refBuf.append(", ");
            } else {
                first = false;
            }
            buf.append(join.getSourceName());
            refBuf.append(join.getTargetName());
        }
        buf.append(") REFERENCES ");
        buf.append(dstName);
        buf.append(" (");
        buf.append(refBuf.toString());
        buf.append(')');
        buf.append(" ON DELETE CASCADE");
        return buf.toString();
    }

    public String dropTable(DbEntity ent) {
        return "DROP TABLE " + ent.getName();
    }

    public String createTable(DbEntity ent) {
        String sql = super.createTable(ent);
        if (sql != null && sql.toUpperCase().startsWith("CREATE TABLE ")) {
            sql = "CREATE CACHED TABLE " + sql.substring("CREATE TABLE ".length());
        }
        String fqnCreate = "CREATE CACHED TABLE " + ent.getFullyQualifiedName() + " (";
        if (sql != null && sql.toUpperCase().startsWith(fqnCreate)) {
            sql = "CREATE CACHED TABLE " + ent.getName() + " (" + sql.substring(fqnCreate.length());
        }
        return sql;
    }
}

