/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dba.oracle;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.access.DataNode;
import org.objectstyle.cayenne.access.OperationObserver;
import org.objectstyle.cayenne.access.trans.QualifierTranslator;
import org.objectstyle.cayenne.access.trans.QueryAssembler;
import org.objectstyle.cayenne.access.trans.TrimmingQualifierTranslator;
import org.objectstyle.cayenne.access.types.ByteArrayType;
import org.objectstyle.cayenne.access.types.ByteType;
import org.objectstyle.cayenne.access.types.CharType;
import org.objectstyle.cayenne.access.types.DefaultType;
import org.objectstyle.cayenne.access.types.ExtendedTypeMap;
import org.objectstyle.cayenne.access.types.ShortType;
import org.objectstyle.cayenne.dba.JdbcAdapter;
import org.objectstyle.cayenne.dba.PkGenerator;
import org.objectstyle.cayenne.dba.oracle.OracleActionBuilder;
import org.objectstyle.cayenne.dba.oracle.OracleDataNode;
import org.objectstyle.cayenne.dba.oracle.OraclePkGenerator;
import org.objectstyle.cayenne.dba.oracle.OracleSelectTranslator;
import org.objectstyle.cayenne.dba.oracle.OracleUtilDateType;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.query.BatchQuery;
import org.objectstyle.cayenne.query.InsertBatchQuery;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.SQLAction;
import org.objectstyle.cayenne.query.SelectQuery;
import org.objectstyle.cayenne.query.UpdateBatchQuery;
import org.objectstyle.cayenne.util.Util;

public class OracleAdapter
extends JdbcAdapter {
    private static Logger logObj = Logger.getLogger(OracleAdapter.class);
    public static final String ORACLE_FLOAT = "FLOAT";
    public static final String ORACLE_BLOB = "BLOB";
    public static final String ORACLE_CLOB = "CLOB";
    public static final String TRIM_FUNCTION = "RTRIM";
    public static final String NEW_CLOB_FUNCTION = "EMPTY_CLOB()";
    public static final String NEW_BLOB_FUNCTION = "EMPTY_BLOB()";
    protected static boolean initDone;
    protected static int oracleCursorType;
    protected static Method outputStreamFromBlobMethod;
    protected static Method writerFromClobMethod;
    protected static boolean supportsOracleLOB;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;

    protected static void initDriverInformation() {
        initDone = true;
        try {
            Class<?> oraTypes = Class.forName("oracle.jdbc.driver.OracleTypes");
            Field cursorField = oraTypes.getField("CURSOR");
            oracleCursorType = cursorField.getInt(null);
            outputStreamFromBlobMethod = Class.forName("oracle.sql.BLOB").getMethod("getBinaryOutputStream", new Class[0]);
            writerFromClobMethod = Class.forName("oracle.sql.CLOB").getMethod("getCharacterOutputStream", new Class[0]);
            supportsOracleLOB = true;
        }
        catch (Throwable th) {
            logObj.debug("Error getting Oracle driver information, ignoring. Note that certain adapter features will be disabled.", Util.unwindException(th));
        }
    }

    public static Method getOutputStreamFromBlobMethod() {
        return outputStreamFromBlobMethod;
    }

    public static boolean isSupportsOracleLOB() {
        return supportsOracleLOB;
    }

    static boolean updatesLOBColumns(BatchQuery query) {
        boolean isInsert = query instanceof InsertBatchQuery;
        boolean isUpdate = query instanceof UpdateBatchQuery;
        if (!isInsert && !isUpdate) {
            return false;
        }
        List updatedAttributes = isInsert ? query.getDbAttributes() : ((UpdateBatchQuery)query).getUpdatedAttributes();
        Iterator it = updatedAttributes.iterator();
        while (it.hasNext()) {
            int type = ((DbAttribute)it.next()).getType();
            if (type != 2005 && type != 2004) continue;
            return true;
        }
        return false;
    }

    public static Method getWriterFromClobMethod() {
        return writerFromClobMethod;
    }

    public static int getOracleCursorType() {
        if (oracleCursorType == Integer.MAX_VALUE) {
            throw new CayenneRuntimeException("No information exists about oracle types. Check that Oracle JDBC driver is available to the application.");
        }
        return oracleCursorType;
    }

    public OracleAdapter() {
        this.setSupportsBatchUpdates(true);
    }

    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new CharType(true, true));
        map.registerType(new ByteArrayType(true, true));
        map.registerType(new OracleUtilDateType());
        map.registerType(new ShortType(true));
        map.registerType(new ByteType(true));
        map.registerType(new OracleIntegerType());
        map.registerType(new OracleDoubleType());
    }

    protected PkGenerator createPkGenerator() {
        return new OraclePkGenerator();
    }

    public String dropTable(DbEntity ent) {
        return "DROP TABLE " + ent.getFullyQualifiedName() + " CASCADE CONSTRAINTS";
    }

    public DbAttribute buildAttribute(String name, String typeName, int type, int size, int precision, boolean allowNulls) {
        DbAttribute attr = super.buildAttribute(name, typeName, type, size, precision, allowNulls);
        if (type == 3 && precision <= 0) {
            attr.setType(4);
            attr.setPrecision(-1);
        } else if (type == 1111) {
            if (ORACLE_FLOAT.equals(typeName)) {
                attr.setType(6);
            } else if (ORACLE_BLOB.equals(typeName)) {
                attr.setType(2004);
            } else if (ORACLE_CLOB.equals(typeName)) {
                attr.setType(2005);
            }
        } else if (type == 91 && "DATE".equals(typeName)) {
            attr.setType(93);
        }
        return attr;
    }

    protected Class queryTranslatorClass(Query q) {
        if (q instanceof SelectQuery) {
            return OracleSelectTranslator.class;
        }
        return super.queryTranslatorClass(q);
    }

    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        return new TrimmingQualifierTranslator(queryAssembler, TRIM_FUNCTION);
    }

    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new OracleActionBuilder(this, node.getEntityResolver()));
    }

    public boolean shouldRunBatchQuery(DataNode node, Connection con, BatchQuery query, OperationObserver delegate) throws SQLException, Exception {
        if (OracleAdapter.isSupportsOracleLOB() && OracleAdapter.updatesLOBColumns(query) && node instanceof OracleDataNode) {
            OracleDataNode oracleNode = (OracleDataNode)node;
            oracleNode.runBatchUpdateWithLOBColumns(con, query, delegate);
            return false;
        }
        return super.shouldRunBatchQuery(node, con, query, delegate);
    }

    static {
        oracleCursorType = Integer.MAX_VALUE;
        OracleAdapter.initDriverInformation();
    }

    final class OracleDoubleType
    extends DefaultType {
        public OracleDoubleType() {
            super((class$java$lang$Double == null ? (class$java$lang$Double = OracleAdapter.class$("java.lang.Double")) : class$java$lang$Double).getName());
        }

        public void setJdbcObject(PreparedStatement st, Object val, int pos, int type, int precision) throws Exception {
            if (val != null) {
                st.setDouble(pos, ((Number)val).doubleValue());
            } else {
                super.setJdbcObject(st, val, pos, type, precision);
            }
        }
    }

    final class OracleIntegerType
    extends DefaultType {
        public OracleIntegerType() {
            super((class$java$lang$Integer == null ? (class$java$lang$Integer = OracleAdapter.class$("java.lang.Integer")) : class$java$lang$Integer).getName());
        }

        public void setJdbcObject(PreparedStatement st, Object val, int pos, int type, int precision) throws Exception {
            if (val != null) {
                st.setInt(pos, ((Number)val).intValue());
            } else {
                super.setJdbcObject(st, val, pos, type, precision);
            }
        }
    }
}

