/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dba.sqlserver;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Iterator;
import org.objectstyle.cayenne.access.OperationObserver;
import org.objectstyle.cayenne.access.QueryLogger;
import org.objectstyle.cayenne.access.jdbc.BatchAction;
import org.objectstyle.cayenne.dba.DbAdapter;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.query.BatchQuery;
import org.objectstyle.cayenne.query.InsertBatchQuery;

public class SQLServerBatchAction
extends BatchAction {
    public SQLServerBatchAction(BatchQuery batchQuery, DbAdapter adapter, EntityResolver entityResolver) {
        super(batchQuery, adapter, entityResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        boolean identityOverride = this.expectsToOverrideIdentityColumns();
        if (identityOverride) {
            this.setIdentityInsert(connection, true);
        }
        try {
            super.performAction(connection, observer);
        }
        finally {
            if (identityOverride) {
                this.setIdentityInsert(connection, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setIdentityInsert(Connection connection, boolean on) throws SQLException {
        String flag = on ? " ON" : " OFF";
        String configSQL = "SET IDENTITY_INSERT " + this.query.getDbEntity().getFullyQualifiedName() + flag;
        QueryLogger.logQuery(configSQL, Collections.EMPTY_LIST);
        Statement statement = connection.createStatement();
        try {
            statement.execute(configSQL);
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    protected boolean expectsToOverrideIdentityColumns() {
        if (this.getAdapter().supportsGeneratedKeys()) {
            return false;
        }
        if (!(this.query instanceof InsertBatchQuery) || this.query.getDbEntity() == null) {
            return false;
        }
        Iterator it = this.query.getDbEntity().getAttributes().iterator();
        while (it.hasNext()) {
            DbAttribute attribute = (DbAttribute)it.next();
            if (!attribute.isGenerated()) continue;
            return true;
        }
        return false;
    }
}

