/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dba.sqlserver;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Level;
import org.objectstyle.cayenne.access.OperationObserver;
import org.objectstyle.cayenne.access.QueryLogger;
import org.objectstyle.cayenne.access.ResultIterator;
import org.objectstyle.cayenne.access.jdbc.ProcedureAction;
import org.objectstyle.cayenne.access.jdbc.RowDescriptor;
import org.objectstyle.cayenne.access.trans.ProcedureTranslator;
import org.objectstyle.cayenne.dba.DbAdapter;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.query.ProcedureQuery;
import org.objectstyle.cayenne.query.Query;

public class SQLServerProcedureAction
extends ProcedureAction {
    public SQLServerProcedureAction(ProcedureQuery query, DbAdapter adapter, EntityResolver entityResolver) {
        super(query, adapter, entityResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        ProcedureTranslator transl = new ProcedureTranslator();
        transl.setAdapter(this.getAdapter());
        transl.setQuery(this.query);
        transl.setEntityResolver(this.getEntityResolver());
        transl.setConnection(connection);
        CallableStatement statement = (CallableStatement)transl.createStatement();
        try {
            boolean hasResultSet = statement.execute();
            Observer localObserver = new Observer(observer);
            while (true) {
                if (hasResultSet) {
                    ResultSet rs = statement.getResultSet();
                    try {
                        RowDescriptor descriptor = this.describeResultSet(rs, this.processedResultSets++);
                        this.readResultSet(rs, descriptor, this.query, localObserver);
                    }
                    finally {
                        try {
                            rs.close();
                        }
                        catch (SQLException ex) {}
                    }
                }
                int updateCount = statement.getUpdateCount();
                if (updateCount == -1) break;
                QueryLogger.logUpdateCount(updateCount);
                localObserver.nextCount(this.query, updateCount);
                hasResultSet = statement.getMoreResults();
            }
            this.readProcedureOutParameters(statement, observer);
            localObserver.flushResults(this.query);
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException ex) {}
        }
    }

    class Observer
    implements OperationObserver {
        List results;
        List counts;
        OperationObserver observer;

        Observer(OperationObserver observer) {
            this.observer = observer;
        }

        void flushResults(Query query) {
            Iterator it;
            if (this.results != null) {
                it = this.results.iterator();
                while (it.hasNext()) {
                    this.observer.nextDataRows(query, (List)it.next());
                }
                this.results = null;
            }
            if (this.counts != null) {
                it = this.counts.iterator();
                while (it.hasNext()) {
                    this.observer.nextCount(query, ((Number)it.next()).intValue());
                }
                this.counts = null;
            }
        }

        public void nextBatchCount(Query query, int[] resultCount) {
            this.observer.nextBatchCount(query, resultCount);
        }

        public void nextCount(Query query, int resultCount) {
            if (this.counts == null) {
                this.counts = new ArrayList();
            }
            this.counts.add(new Integer(resultCount));
        }

        public void nextDataRows(Query query, List dataRows) {
            if (this.results == null) {
                this.results = new ArrayList();
            }
            this.results.add(dataRows);
        }

        public void nextDataRows(Query q, ResultIterator it) {
            this.observer.nextDataRows(q, it);
        }

        public void nextGlobalException(Exception ex) {
            this.observer.nextGlobalException(ex);
        }

        public void nextGeneratedDataRows(Query query, ResultIterator keysIterator) {
            this.observer.nextGeneratedDataRows(query, keysIterator);
        }

        public void nextQueryException(Query query, Exception ex) {
            this.observer.nextQueryException(query, ex);
        }

        public Level getLoggingLevel() {
            return this.observer.getLoggingLevel();
        }

        public boolean isIteratedResult() {
            return this.observer.isIteratedResult();
        }
    }
}

