/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.exp.parser;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import org.objectstyle.cayenne.exp.Expression;
import org.objectstyle.cayenne.exp.parser.SimpleNode;
import org.objectstyle.cayenne.util.ConversionUtil;

public class ASTMultiply
extends SimpleNode {
    ASTMultiply(int id) {
        super(id);
    }

    public ASTMultiply() {
        super(22);
    }

    public ASTMultiply(Object[] nodes) {
        super(22);
        int len = nodes.length;
        for (int i = 0; i < len; ++i) {
            this.jjtAddChild(this.wrapChild(nodes[i]), i);
        }
    }

    public ASTMultiply(Collection nodes) {
        super(22);
        int len = nodes.size();
        Iterator it = nodes.iterator();
        for (int i = 0; i < len; ++i) {
            this.jjtAddChild(this.wrapChild(it.next()), i);
        }
    }

    protected Object evaluateNode(Object o) throws Exception {
        int len = this.jjtGetNumChildren();
        if (len == 0) {
            return null;
        }
        BigDecimal result = null;
        for (int i = 0; i < len; ++i) {
            BigDecimal value = ConversionUtil.toBigDecimal(this.evaluateChild(i, o));
            if (value == null) {
                return null;
            }
            result = i == 0 ? value : result.multiply(value);
        }
        return result;
    }

    public Expression shallowCopy() {
        return new ASTMultiply(this.id);
    }

    protected String getExpressionOperator(int index) {
        return "*";
    }

    public int getType() {
        return 18;
    }

    public void jjtClose() {
        super.jjtClose();
        this.flattenTree();
    }
}

