/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.gen;

import java.util.Iterator;
import org.objectstyle.cayenne.gen.StringUtils;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.map.MappingNamespace;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.Relationship;

public class EntityUtils {
    protected String subClassName;
    protected String superClassName;
    protected String baseClassName;
    protected String subPackageName;
    protected String superPackageName;
    protected String basePackageName;
    protected DataMap primaryDataMap;
    protected ObjEntity objEntity;

    public EntityUtils(DataMap dataMap, ObjEntity objEntity, String fqnBaseClass, String fqnSuperClass, String fqnSubClass) {
        StringUtils stringUtils = StringUtils.getInstance();
        this.baseClassName = stringUtils.stripPackageName(fqnBaseClass);
        this.basePackageName = stringUtils.stripClass(fqnBaseClass);
        this.superClassName = stringUtils.stripPackageName(fqnSuperClass);
        this.superPackageName = stringUtils.stripClass(fqnSuperClass);
        this.subClassName = stringUtils.stripPackageName(fqnSubClass);
        this.subPackageName = stringUtils.stripClass(fqnSubClass);
        this.primaryDataMap = dataMap;
        this.objEntity = objEntity;
    }

    public String getSubClassName() {
        return this.subClassName;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public String getBaseClassName() {
        return this.baseClassName;
    }

    public String getSubPackageName() {
        return this.subPackageName;
    }

    public String getSuperPackageName() {
        return this.superPackageName;
    }

    public String getBasePackageName() {
        return this.basePackageName;
    }

    public DataMap getPrimaryDataMap() {
        return this.primaryDataMap;
    }

    public MappingNamespace getEntityResolver() {
        return this.primaryDataMap.getNamespace();
    }

    public boolean hasToManyRelationships() {
        return this.hasToManyRelationships(this.objEntity);
    }

    public boolean hasToManyRelationships(ObjEntity anObjEntity) {
        if (anObjEntity == null) {
            return false;
        }
        Iterator it = anObjEntity.getRelationships().iterator();
        while (it.hasNext()) {
            Relationship r = (Relationship)it.next();
            if (!r.isToMany()) continue;
            return true;
        }
        return false;
    }

    public boolean hasToManyDeclaredRelationships() {
        return this.hasToManyDeclaredRelationships(this.objEntity);
    }

    public boolean hasToManyDeclaredRelationships(ObjEntity anObjEntity) {
        if (anObjEntity == null) {
            return false;
        }
        Iterator it = anObjEntity.getDeclaredRelationships().iterator();
        while (it.hasNext()) {
            Relationship r = (Relationship)it.next();
            if (!r.isToMany()) continue;
            return true;
        }
        return false;
    }

    public boolean hasToOneRelationships() {
        return this.hasToOneRelationships(this.objEntity);
    }

    public boolean hasToOneRelationships(ObjEntity anObjEntity) {
        if (anObjEntity == null) {
            return false;
        }
        Iterator it = anObjEntity.getRelationships().iterator();
        while (it.hasNext()) {
            Relationship r = (Relationship)it.next();
            if (r.isToMany()) continue;
            return true;
        }
        return false;
    }

    public boolean hasToOneDeclaredRelationships() {
        return this.hasToOneDeclaredRelationships(this.objEntity);
    }

    public boolean hasToOneDeclaredRelationships(ObjEntity anObjEntity) {
        if (anObjEntity == null) {
            return false;
        }
        Iterator it = anObjEntity.getDeclaredRelationships().iterator();
        while (it.hasNext()) {
            Relationship r = (Relationship)it.next();
            if (r.isToMany()) continue;
            return true;
        }
        return false;
    }
}

