/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.map;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.map.Entity;
import org.objectstyle.cayenne.map.Relationship;
import org.objectstyle.cayenne.util.XMLEncoder;
import org.objectstyle.cayenne.util.XMLSerializable;

public class DbJoin
implements XMLSerializable {
    protected DbRelationship relationship;
    protected String sourceName;
    protected String targetName;

    protected DbJoin() {
    }

    public DbJoin(DbRelationship relationship) {
        this.relationship = relationship;
    }

    public DbJoin(DbRelationship relationship, String sourceName, String targetName) {
        this.relationship = relationship;
        this.sourceName = sourceName;
        this.targetName = targetName;
    }

    public DbJoin createReverseJoin() {
        DbJoin reverse = new DbJoin();
        reverse.setTargetName(this.sourceName);
        reverse.setSourceName(this.targetName);
        return reverse;
    }

    public DbAttribute getSource() {
        if (this.sourceName == null) {
            return null;
        }
        DbRelationship r = this.getNonNullRelationship();
        Entity entity = r.getSourceEntity();
        if (entity == null) {
            return null;
        }
        return (DbAttribute)entity.getAttribute(this.sourceName);
    }

    public DbAttribute getTarget() {
        if (this.targetName == null) {
            return null;
        }
        DbRelationship r = this.getNonNullRelationship();
        Entity entity = ((Relationship)r).getTargetEntity();
        if (entity == null) {
            return null;
        }
        return (DbAttribute)entity.getAttribute(this.targetName);
    }

    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<db-attribute-pair");
        if (this.getSourceName() != null) {
            encoder.print(" source=\"");
            encoder.print(this.getSourceName());
            encoder.print("\"");
        }
        if (this.getTargetName() != null) {
            encoder.print(" target=\"");
            encoder.print(this.getTargetName());
            encoder.print("\"");
        }
        encoder.println("/>");
    }

    public DbRelationship getRelationship() {
        return this.relationship;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setRelationship(DbRelationship relationship) {
        this.relationship = relationship;
    }

    public void setSourceName(String string) {
        this.sourceName = string;
    }

    public void setTargetName(String string) {
        this.targetName = string;
    }

    private final DbRelationship getNonNullRelationship() {
        if (this.relationship == null) {
            throw new CayenneRuntimeException("Join has no parent Relationship.");
        }
        return this.relationship;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this);
        builder.append("source", this.getSourceName());
        builder.append("target", this.getTargetName());
        return builder.toString();
    }
}

