/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.map;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.dba.TypesMapping;
import org.objectstyle.cayenne.exp.Expression;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.DbJoin;
import org.objectstyle.cayenne.map.DbKeyGenerator;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.map.DeleteRule;
import org.objectstyle.cayenne.map.DerivedDbAttribute;
import org.objectstyle.cayenne.map.DerivedDbEntity;
import org.objectstyle.cayenne.map.ObjAttribute;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.ObjRelationship;
import org.objectstyle.cayenne.map.Procedure;
import org.objectstyle.cayenne.map.ProcedureParameter;
import org.objectstyle.cayenne.map.QueryBuilder;
import org.objectstyle.cayenne.map.SelectQueryBuilder;
import org.objectstyle.cayenne.util.ResourceLocator;
import org.objectstyle.cayenne.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class MapLoader
extends DefaultHandler {
    public static final String DATA_MAP_TAG = "data-map";
    public static final String PROPERTY_TAG = "property";
    public static final String DB_ENTITY_TAG = "db-entity";
    public static final String OBJ_ENTITY_TAG = "obj-entity";
    public static final String DB_ATTRIBUTE_TAG = "db-attribute";
    public static final String DB_ATTRIBUTE_DERIVED_TAG = "db-attribute-derived";
    public static final String DB_ATTRIBUTE_REF_TAG = "db-attribute-ref";
    public static final String OBJ_ATTRIBUTE_TAG = "obj-attribute";
    public static final String OBJ_RELATIONSHIP_TAG = "obj-relationship";
    public static final String DB_RELATIONSHIP_TAG = "db-relationship";
    public static final String DB_RELATIONSHIP_REF_TAG = "db-relationship-ref";
    public static final String DB_ATTRIBUTE_PAIR_TAG = "db-attribute-pair";
    public static final String PROCEDURE_TAG = "procedure";
    public static final String PROCEDURE_PARAMETER_TAG = "procedure-parameter";
    public static final String QUERY_TAG = "query";
    public static final String QUERY_RESULT_COLUMN_TAG = "result-column";
    public static final String QUERY_SQL_TAG = "sql";
    public static final String QUERY_QUALIFIER_TAG = "qualifier";
    public static final String QUERY_ORDERING_TAG = "ordering";
    public static final String QUERY_PREFETCH_TAG = "prefetch";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String DB_KEY_GENERATOR_TAG = "db-key-generator";
    public static final String DB_GENERATOR_TYPE_TAG = "db-generator-type";
    public static final String DB_GENERATOR_NAME_TAG = "db-generator-name";
    public static final String DB_KEY_CACHE_SIZE_TAG = "db-key-cache-size";
    private DataMap dataMap;
    private DbEntity dbEntity;
    private ObjEntity objEntity;
    private DbRelationship dbRelationship;
    private ObjRelationship objRelationship;
    private DbAttribute attrib;
    private Procedure procedure;
    private QueryBuilder queryBuilder;
    private String sqlKey;
    private String descending;
    private String ignoreCase;
    private String currentTag;
    private StringBuffer charactersBuffer;
    private Map mapProperties;

    public synchronized DataMap loadDataMap(InputSource src) throws CayenneRuntimeException {
        if (src == null) {
            throw new NullPointerException("Null InputSource.");
        }
        try {
            String mapName = this.mapNameFromLocation(src.getSystemId());
            this.dataMap = new DataMap(mapName);
            XMLReader parser = Util.createXmlReader();
            parser.setContentHandler(this);
            parser.setErrorHandler(this);
            parser.parse(src);
        }
        catch (SAXException e) {
            this.dataMap = null;
            throw new CayenneRuntimeException("Wrong DataMap format, last processed tag: <" + this.currentTag, Util.unwindException(e));
        }
        catch (Exception e) {
            this.dataMap = null;
            throw new CayenneRuntimeException("Error loading DataMap, last processed tag: <" + this.currentTag, Util.unwindException(e));
        }
        return this.dataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataMap loadDataMap(String uri) throws CayenneRuntimeException {
        ResourceLocator locator = this.configLocator();
        InputStream in = locator.findResourceStream(uri);
        if (in == null) {
            throw new CayenneRuntimeException("Can't find data map " + uri);
        }
        try {
            InputSource inSrc = new InputSource(in);
            inSrc.setSystemId(uri);
            DataMap dataMap = this.loadDataMap(inSrc);
            return dataMap;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioex) {}
        }
    }

    protected String mapNameFromLocation(String location) {
        if (location == null) {
            return "Untitled";
        }
        int lastSlash = location.lastIndexOf(47);
        if (lastSlash < 0) {
            lastSlash = location.lastIndexOf(92);
        }
        if (lastSlash >= 0 && lastSlash + 1 < location.length()) {
            location = location.substring(lastSlash + 1);
        }
        if (location.endsWith(".map.xml")) {
            location = location.substring(0, location.length() - ".map.xml".length());
        }
        return location;
    }

    protected ResourceLocator configLocator() {
        ResourceLocator locator = new ResourceLocator();
        locator.setSkipAbsolutePath(true);
        locator.setSkipClasspath(false);
        locator.setSkipCurrentDirectory(false);
        locator.setSkipHomeDirectory(false);
        return locator;
    }

    public void startElement(String namespaceUri, String localName, String qName, Attributes attributes) throws SAXException {
        this.rememberCurrentTag(localName);
        if (!localName.equals(DATA_MAP_TAG)) {
            if (localName.equals(DB_ENTITY_TAG)) {
                this.processStartDbEntity(attributes);
            } else if (localName.equals(DB_ATTRIBUTE_TAG)) {
                this.processStartDbAttribute(attributes);
            } else if (localName.equals(DB_ATTRIBUTE_DERIVED_TAG)) {
                this.processStartDerivedDbAttribute(attributes);
            } else if (localName.equals(DB_ATTRIBUTE_REF_TAG)) {
                this.processStartDbAttributeRef(attributes);
            } else if (localName.equals(OBJ_ENTITY_TAG)) {
                this.processStartObjEntity(attributes);
            } else if (localName.equals(OBJ_ATTRIBUTE_TAG)) {
                this.processStartObjAttribute(attributes);
            } else if (localName.equals(DB_RELATIONSHIP_TAG)) {
                this.processStartDbRelationship(attributes);
            } else if (localName.equals(DB_ATTRIBUTE_PAIR_TAG)) {
                this.processStartDbAttributePair(attributes);
            } else if (localName.equals(OBJ_RELATIONSHIP_TAG)) {
                this.processStartObjRelationship(attributes);
            } else if (localName.equals(DB_RELATIONSHIP_REF_TAG)) {
                this.processStartDbRelationshipRef(attributes);
            } else if (localName.equals(PROCEDURE_PARAMETER_TAG)) {
                this.processStartProcedureParameter(attributes);
            } else if (localName.equals(PROCEDURE_TAG)) {
                this.processStartProcedure(attributes);
            } else if (localName.equals(QUERY_TAG)) {
                this.processStartQuery(attributes);
            } else if (localName.equals(QUERY_SQL_TAG)) {
                this.charactersBuffer = new StringBuffer();
                this.processStartQuerySQL(attributes);
            } else if (localName.equals(QUERY_ORDERING_TAG)) {
                this.charactersBuffer = new StringBuffer();
                this.processStartQueryOrdering(attributes);
            } else if (localName.equals(QUERY_PREFETCH_TAG)) {
                this.charactersBuffer = new StringBuffer();
            } else if (localName.equals(QUERY_QUALIFIER_TAG)) {
                this.charactersBuffer = new StringBuffer();
            } else if (localName.equals(DB_KEY_GENERATOR_TAG)) {
                this.processStartDbKeyGenerator(attributes);
            } else if (localName.equals(DB_GENERATOR_TYPE_TAG)) {
                this.charactersBuffer = new StringBuffer();
            } else if (localName.equals(DB_GENERATOR_NAME_TAG)) {
                this.charactersBuffer = new StringBuffer();
            } else if (localName.equals(DB_KEY_CACHE_SIZE_TAG)) {
                this.charactersBuffer = new StringBuffer();
            } else if (localName.equals(PROPERTY_TAG)) {
                if (this.queryBuilder != null) {
                    this.processStartQueryProperty(attributes);
                } else {
                    this.processStartDataMapProperty(attributes);
                }
            }
        }
    }

    public void endElement(String namespaceURI, String local_name, String qName) throws SAXException {
        if (local_name.equals(DATA_MAP_TAG)) {
            this.processEndDataMap();
        } else if (local_name.equals(DB_ENTITY_TAG)) {
            this.processEndDbEntity();
        } else if (local_name.equals(OBJ_ENTITY_TAG)) {
            this.processEndObjEntity();
        } else if (local_name.equals(DB_ATTRIBUTE_TAG)) {
            this.processEndDbAttribute();
        } else if (local_name.equals(DB_ATTRIBUTE_DERIVED_TAG)) {
            this.processEndDbAttribute();
        } else if (local_name.equals(DB_RELATIONSHIP_TAG)) {
            this.processEndDbRelationship();
        } else if (local_name.equals(OBJ_RELATIONSHIP_TAG)) {
            this.processEndObjRelationship();
        } else if (!local_name.equals(DB_KEY_GENERATOR_TAG)) {
            if (local_name.equals(DB_GENERATOR_TYPE_TAG)) {
                this.processEndDbGeneratorType();
            } else if (local_name.equals(DB_GENERATOR_NAME_TAG)) {
                this.processEndDbGeneratorName();
            } else if (local_name.equals(DB_KEY_CACHE_SIZE_TAG)) {
                this.processEndDbKeyCacheSize();
            } else if (local_name.equals(PROCEDURE_PARAMETER_TAG)) {
                this.processEndProcedureParameter();
            } else if (local_name.equals(PROCEDURE_TAG)) {
                this.processEndProcedure();
            } else if (local_name.equals(QUERY_TAG)) {
                this.processEndQuery();
            } else if (local_name.equals(QUERY_SQL_TAG)) {
                this.processEndQuerySQL();
            } else if (local_name.equals(QUERY_QUALIFIER_TAG)) {
                this.processEndQualifier();
            } else if (local_name.equals(QUERY_ORDERING_TAG)) {
                this.processEndQueryOrdering();
            } else if (local_name.equals(QUERY_PREFETCH_TAG)) {
                this.processEndQueryPrefetch();
            }
        }
        this.resetCurrentTag();
        this.charactersBuffer = null;
    }

    private void processStartDbEntity(Attributes atts) {
        String name = atts.getValue("", "name");
        String parentName = atts.getValue("", "parentName");
        if (parentName != null) {
            this.dbEntity = new DerivedDbEntity(name);
            ((DerivedDbEntity)this.dbEntity).setParentEntityName(parentName);
        } else {
            this.dbEntity = new DbEntity(name);
        }
        if (!(this.dbEntity instanceof DerivedDbEntity)) {
            this.dbEntity.setSchema(atts.getValue("", "schema"));
            this.dbEntity.setCatalog(atts.getValue("", "catalog"));
        }
        this.dataMap.addDbEntity(this.dbEntity);
    }

    private void processStartDbAttributeRef(Attributes atts) throws SAXException {
        String name = atts.getValue("", "name");
        if (!(this.attrib instanceof DerivedDbAttribute) || !(this.dbEntity instanceof DerivedDbEntity)) {
            throw new SAXException("Referenced attributes are not supported by regular DbAttributes.  Offending attribute name '" + this.attrib.getName() + "'.");
        }
        DbEntity parent = ((DerivedDbEntity)this.dbEntity).getParentEntity();
        DbAttribute ref = (DbAttribute)parent.getAttribute(name);
        ((DerivedDbAttribute)this.attrib).addParam(ref);
    }

    private void processStartDbAttribute(Attributes atts) {
        String precision;
        String name = atts.getValue("", "name");
        String type = atts.getValue("", "type");
        this.attrib = new DbAttribute(name);
        this.attrib.setType(TypesMapping.getSqlTypeByName(type));
        this.dbEntity.addAttribute(this.attrib);
        String length = atts.getValue("", "length");
        if (length != null) {
            this.attrib.setMaxLength(Integer.parseInt(length));
        }
        if ((precision = atts.getValue("", "precision")) != null) {
            this.attrib.setPrecision(Integer.parseInt(precision));
        }
        this.attrib.setPrimaryKey(TRUE.equalsIgnoreCase(atts.getValue("", "isPrimaryKey")));
        this.attrib.setMandatory(TRUE.equalsIgnoreCase(atts.getValue("", "isMandatory")));
        this.attrib.setGenerated(TRUE.equalsIgnoreCase(atts.getValue("", "isGenerated")));
    }

    private void processStartDerivedDbAttribute(Attributes atts) {
        String name = atts.getValue("", "name");
        String type = atts.getValue("", "type");
        String spec = atts.getValue("", "spec");
        this.attrib = new DerivedDbAttribute(name);
        this.attrib.setType(TypesMapping.getSqlTypeByName(type));
        ((DerivedDbAttribute)this.attrib).setExpressionSpec(spec);
        this.dbEntity.addAttribute(this.attrib);
        String temp = atts.getValue("", "length");
        if (temp != null) {
            this.attrib.setMaxLength(Integer.parseInt(temp));
        }
        if ((temp = atts.getValue("", "precision")) != null) {
            this.attrib.setPrecision(Integer.parseInt(temp));
        }
        if ((temp = atts.getValue("", "isPrimaryKey")) != null && temp.equalsIgnoreCase(TRUE)) {
            this.attrib.setPrimaryKey(true);
        }
        if ((temp = atts.getValue("", "isMandatory")) != null && temp.equalsIgnoreCase(TRUE)) {
            this.attrib.setMandatory(true);
        }
        if ((temp = atts.getValue("", "isGroupBy")) != null && temp.equalsIgnoreCase(TRUE)) {
            ((DerivedDbAttribute)this.attrib).setGroupBy(true);
        }
    }

    private void processStartDbKeyGenerator(Attributes atts) {
        DbKeyGenerator pkGenerator = new DbKeyGenerator();
        this.dbEntity.setPrimaryKeyGenerator(pkGenerator);
    }

    private void processStartQuerySQL(Attributes atts) {
        this.sqlKey = atts.getValue("", "adapter-class");
    }

    private void processStartObjEntity(Attributes atts) {
        String superEntityName;
        this.objEntity = new ObjEntity(atts.getValue("", "name"));
        this.objEntity.setClassName(atts.getValue("", "className"));
        this.objEntity.setClientClassName(atts.getValue("", "clientClassName"));
        String readOnly = atts.getValue("", "readOnly");
        this.objEntity.setReadOnly(TRUE.equalsIgnoreCase(readOnly));
        String serverOnly = atts.getValue("", "serverOnly");
        this.objEntity.setServerOnly(TRUE.equalsIgnoreCase(serverOnly));
        String lockType = atts.getValue("", "lock-type");
        if ("optimistic".equals(lockType)) {
            this.objEntity.setDeclaredLockType(1);
        }
        if ((superEntityName = atts.getValue("", "superEntityName")) != null) {
            this.objEntity.setSuperEntityName(superEntityName);
        } else {
            this.objEntity.setDbEntityName(atts.getValue("", "dbEntityName"));
            this.objEntity.setSuperClassName(atts.getValue("", "superClassName"));
            this.objEntity.setClientSuperClassName(atts.getValue("", "clientSuperClassName"));
        }
        this.dataMap.addObjEntity(this.objEntity);
    }

    private void processStartObjAttribute(Attributes atts) {
        String name = atts.getValue("", "name");
        String type = atts.getValue("", "type");
        String lock = atts.getValue("", "lock");
        ObjAttribute oa = new ObjAttribute(name);
        oa.setType(type);
        oa.setUsedForLocking(TRUE.equalsIgnoreCase(lock));
        this.objEntity.addAttribute(oa);
        String dbPath = atts.getValue("", "db-attribute-path");
        if (dbPath == null) {
            dbPath = atts.getValue("", "db-attribute-name");
        }
        oa.setDbAttributePath(dbPath);
    }

    private void processStartDbRelationship(Attributes atts) throws SAXException {
        String name = atts.getValue("", "name");
        if (name == null) {
            throw new SAXException("MapLoader::processStartDbRelationship(), Unable to parse name. Attributes:\n" + this.printAttributes(atts).toString());
        }
        String sourceName = atts.getValue("", "source");
        if (sourceName == null) {
            throw new SAXException("MapLoader::processStartDbRelationship() - null source entity");
        }
        DbEntity source = this.dataMap.getDbEntity(sourceName);
        if (source == null) {
            return;
        }
        String toManyString = atts.getValue("", "toMany");
        boolean toMany = toManyString != null && toManyString.equalsIgnoreCase(TRUE);
        String toDependPkString = atts.getValue("", "toDependentPK");
        boolean toDependentPK = toDependPkString != null && toDependPkString.equalsIgnoreCase(TRUE);
        this.dbRelationship = new DbRelationship(name);
        this.dbRelationship.setSourceEntity(source);
        this.dbRelationship.setTargetEntityName(atts.getValue("", "target"));
        this.dbRelationship.setToMany(toMany);
        this.dbRelationship.setToDependentPK(toDependentPK);
        source.addRelationship(this.dbRelationship);
    }

    private void processStartDbRelationshipRef(Attributes atts) throws SAXException {
        String name = atts.getValue("", "name");
        if (name == null) {
            throw new SAXException("MapLoader::processStartDbRelationshipRef(), Null DbRelationship name for " + this.objRelationship.getName());
        }
        String path = this.objRelationship.getDbRelationshipPath();
        path = path != null ? path + "." + name : name;
        this.objRelationship.setDbRelationshipPath(path);
    }

    private void processStartDbAttributePair(Attributes atts) {
        DbJoin join = new DbJoin(this.dbRelationship);
        join.setSourceName(atts.getValue("", "source"));
        join.setTargetName(atts.getValue("", "target"));
        this.dbRelationship.addJoin(join);
    }

    private void processStartObjRelationship(Attributes atts) throws SAXException {
        String name = atts.getValue("", "name");
        if (null == name) {
            throw new SAXException("MapLoader::processStartObjRelationship(), Unable to parse target. Attributes:\n" + this.printAttributes(atts).toString());
        }
        String sourceName = atts.getValue("", "source");
        if (sourceName == null) {
            throw new SAXException("MapLoader::processStartObjRelationship(), Unable to parse source. Attributes:\n" + this.printAttributes(atts).toString());
        }
        ObjEntity source = this.dataMap.getObjEntity(sourceName);
        if (source == null) {
            throw new SAXException("MapLoader::processStartObjRelationship(), Unable to find source " + sourceName);
        }
        String deleteRuleName = atts.getValue("", "deleteRule");
        int deleteRule = deleteRuleName != null ? DeleteRule.deleteRuleForName(deleteRuleName) : 0;
        this.objRelationship = new ObjRelationship(name);
        this.objRelationship.setSourceEntity(source);
        this.objRelationship.setTargetEntityName(atts.getValue("", "target"));
        this.objRelationship.setDeleteRule(deleteRule);
        this.objRelationship.setUsedForLocking(TRUE.equalsIgnoreCase(atts.getValue("", "lock")));
        this.objRelationship.setDbRelationshipPath(atts.getValue("", "db-relationship-path"));
        source.addRelationship(this.objRelationship);
    }

    private void processStartProcedure(Attributes attributes) throws SAXException {
        String name = attributes.getValue("", "name");
        if (null == name) {
            throw new SAXException("MapLoader::processStartProcedure(), no procedure name.");
        }
        String schema = attributes.getValue("", "schema");
        String catalog = attributes.getValue("", "catalog");
        String returningValue = attributes.getValue("", "returningValue");
        this.procedure = new Procedure(name);
        this.procedure.setReturningValue(returningValue != null && returningValue.equalsIgnoreCase(TRUE));
        this.procedure.setSchema(schema);
        this.procedure.setCatalog(catalog);
        this.dataMap.addProcedure(this.procedure);
    }

    private void processStartProcedureParameter(Attributes attributes) throws SAXException {
        String direction;
        String precision;
        String length;
        String name = attributes.getValue("", "name");
        if (name == null) {
            throw new SAXException("MapLoader::processStartProcedureParameter(), no procedure parameter name.");
        }
        ProcedureParameter parameter = new ProcedureParameter(name);
        String type = attributes.getValue("", "type");
        if (type != null) {
            parameter.setType(TypesMapping.getSqlTypeByName(type));
        }
        if ((length = attributes.getValue("", "length")) != null) {
            parameter.setMaxLength(Integer.parseInt(length));
        }
        if ((precision = attributes.getValue("", "precision")) != null) {
            parameter.setPrecision(Integer.parseInt(precision));
        }
        if ("in".equals(direction = attributes.getValue("", "direction"))) {
            parameter.setDirection(1);
        } else if ("out".equals(direction)) {
            parameter.setDirection(2);
        } else if ("in_out".equals(direction)) {
            parameter.setDirection(3);
        }
        this.procedure.addCallParameter(parameter);
    }

    private void processStartQuery(Attributes attributes) throws SAXException {
        String name = attributes.getValue("", "name");
        if (null == name) {
            throw new SAXException("MapLoader::processStartQuery(), no query name.");
        }
        String builder = attributes.getValue("", "factory");
        if (builder == null) {
            builder = SelectQueryBuilder.class.getName();
        } else if (builder.equals("org.objectstyle.cayenne.query.SelectQueryBuilder")) {
            builder = SelectQueryBuilder.class.getName();
        }
        try {
            this.queryBuilder = (QueryBuilder)Class.forName(builder).newInstance();
        }
        catch (Exception ex) {
            throw new SAXException("MapLoader::processStartQuery(), invalid query builder: " + builder);
        }
        String rootType = attributes.getValue("", "root");
        String rootName = attributes.getValue("", "root-name");
        String resultType = attributes.getValue("", "result-type");
        String resultEntity = attributes.getValue("", "result-entity");
        this.queryBuilder.setName(name);
        this.queryBuilder.setRoot(this.dataMap, rootType, rootName);
        if (Util.isEmptyString(resultEntity)) {
            this.queryBuilder.setResultType(resultType);
        } else {
            this.queryBuilder.setResultEntity(resultEntity);
        }
    }

    private void processStartQueryProperty(Attributes attributes) throws SAXException {
        String name = attributes.getValue("", "name");
        if (null == name) {
            throw new SAXException("MapLoader::processStartQueryProperty(), no property name.");
        }
        String value = attributes.getValue("", "value");
        if (null == value) {
            throw new SAXException("MapLoader::processStartQueryProperty(), no property value.");
        }
        this.queryBuilder.addProperty(name, value);
    }

    private void processStartDataMapProperty(Attributes attributes) throws SAXException {
        String name = attributes.getValue("", "name");
        if (null == name) {
            throw new SAXException("MapLoader::processStartDataMapProperty(), no property name.");
        }
        String value = attributes.getValue("", "value");
        if (null == value) {
            throw new SAXException("MapLoader::processStartDataMapProperty(), no property value.");
        }
        if (this.mapProperties == null) {
            this.mapProperties = new TreeMap();
        }
        this.mapProperties.put(name, value);
    }

    private void processEndQueryPrefetch() {
        this.queryBuilder.addPrefetch(this.charactersBuffer.toString());
    }

    private void processStartQueryOrdering(Attributes attributes) {
        this.descending = attributes.getValue("", "descending");
        this.ignoreCase = attributes.getValue("", "ignore-case");
    }

    private void processEndQuery() {
        this.dataMap.addQuery(this.queryBuilder.getQuery());
        this.queryBuilder = null;
    }

    private void processEndQuerySQL() {
        this.queryBuilder.addSql(this.charactersBuffer.toString(), this.sqlKey);
        this.sqlKey = null;
    }

    private void processEndQualifier() {
        String qualifier = this.charactersBuffer.toString();
        if (qualifier.trim().length() == 0) {
            return;
        }
        if (this.objEntity != null) {
            this.objEntity.setDeclaredQualifier(Expression.fromString(qualifier));
        } else {
            this.queryBuilder.setQualifier(qualifier);
        }
    }

    private void processEndQueryOrdering() {
        String path = this.charactersBuffer.toString();
        this.queryBuilder.addOrdering(path, this.descending, this.ignoreCase);
    }

    private void processEndDbAttribute() {
        this.attrib = null;
    }

    private void processEndDbEntity() {
        this.dbEntity = null;
    }

    private void processEndProcedure() {
        this.procedure = null;
    }

    private void processEndProcedureParameter() {
    }

    private void processEndDbGeneratorType() {
        if (this.dbEntity == null) {
            return;
        }
        DbKeyGenerator pkGenerator = this.dbEntity.getPrimaryKeyGenerator();
        if (pkGenerator == null) {
            return;
        }
        pkGenerator.setGeneratorType(this.charactersBuffer.toString());
        if (pkGenerator.getGeneratorType() == null) {
            this.dbEntity.setPrimaryKeyGenerator(null);
        }
    }

    private void processEndDbGeneratorName() {
        if (this.dbEntity == null) {
            return;
        }
        DbKeyGenerator pkGenerator = this.dbEntity.getPrimaryKeyGenerator();
        if (pkGenerator == null) {
            return;
        }
        pkGenerator.setGeneratorName(this.charactersBuffer.toString());
    }

    private void processEndDbKeyCacheSize() {
        if (this.dbEntity == null) {
            return;
        }
        DbKeyGenerator pkGenerator = this.dbEntity.getPrimaryKeyGenerator();
        if (pkGenerator == null) {
            return;
        }
        try {
            pkGenerator.setKeyCacheSize(new Integer(this.charactersBuffer.toString().trim()));
        }
        catch (Exception ex) {
            pkGenerator.setKeyCacheSize(null);
        }
    }

    private void processEndDataMap() {
        if (this.mapProperties != null) {
            this.dataMap.initWithProperties(this.mapProperties);
        }
        this.mapProperties = null;
    }

    private void processEndObjEntity() {
        this.objEntity = null;
    }

    private void processEndDbRelationship() {
        this.dbRelationship = null;
    }

    private void processEndObjRelationship() {
        this.objRelationship = null;
    }

    private StringBuffer printAttributes(Attributes atts) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < atts.getLength(); ++i) {
            String value = atts.getQName(i);
            String name = atts.getValue(i);
            sb.append("Name: " + name + "\tValue: " + value + "\n");
        }
        return sb;
    }

    public void characters(char[] text, int start, int length) throws SAXException {
        if (this.charactersBuffer != null) {
            this.charactersBuffer.append(text, start, length);
        }
    }

    private void rememberCurrentTag(String tag) {
        this.currentTag = tag;
    }

    private void resetCurrentTag() {
        this.currentTag = null;
    }
}

