/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.map;

import java.util.Iterator;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringUtils;
import org.objectstyle.cayenne.CayenneException;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.map.Attribute;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.util.Util;
import org.objectstyle.cayenne.util.XMLEncoder;

public class ObjAttribute
extends Attribute {
    protected String type;
    protected boolean usedForLocking;
    protected String dbAttributePath;

    public ObjAttribute() {
    }

    public ObjAttribute(String name) {
        super(name);
    }

    public ObjAttribute(String name, String type, ObjEntity entity) {
        this.setName(name);
        this.setType(type);
        this.setEntity(entity);
    }

    public Class getJavaClass() {
        if (this.getType() == null) {
            return null;
        }
        try {
            return Util.getJavaClass(this.getType());
        }
        catch (ClassNotFoundException e) {
            throw new CayenneRuntimeException("Failed to load class for name '" + this.getType() + "': " + e.getMessage(), e);
        }
    }

    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<obj-attribute name=\"" + this.getName() + '\"');
        if (this.getType() != null) {
            encoder.print(" type=\"");
            encoder.print(this.getType());
            encoder.print('\"');
        }
        if (this.isUsedForLocking()) {
            encoder.print(" lock=\"true\"");
        }
        if (this.getDbAttribute() != null) {
            encoder.print(" db-attribute-path=\"");
            encoder.print(Util.encodeXmlAttribute(this.getDbAttributePath()));
            encoder.print('\"');
        }
        encoder.println("/>");
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isUsedForLocking() {
        return this.usedForLocking;
    }

    public void setUsedForLocking(boolean usedForLocking) {
        this.usedForLocking = usedForLocking;
    }

    public DbAttribute getDbAttribute() {
        Iterator pathIterator = this.getDbPathIterator();
        Object o = null;
        while (pathIterator.hasNext()) {
            o = pathIterator.next();
        }
        return o;
    }

    public Iterator getDbPathIterator() {
        if (this.dbAttributePath == null) {
            return IteratorUtils.EMPTY_ITERATOR;
        }
        ObjEntity ent = (ObjEntity)this.getEntity();
        if (ent == null) {
            return IteratorUtils.EMPTY_ITERATOR;
        }
        DbEntity dbEnt = ent.getDbEntity();
        if (dbEnt == null) {
            return IteratorUtils.EMPTY_ITERATOR;
        }
        int lastPartStart = this.dbAttributePath.lastIndexOf(46);
        if (lastPartStart < 0) {
            Attribute attribute = dbEnt.getAttribute(this.dbAttributePath);
            if (attribute == null) {
                return IteratorUtils.EMPTY_ITERATOR;
            }
            return IteratorUtils.singletonIterator(attribute);
        }
        return dbEnt.resolvePathComponents(this.dbAttributePath);
    }

    public void setDbAttribute(DbAttribute dbAttribute) {
        if (dbAttribute == null) {
            this.setDbAttributePath(null);
        } else {
            this.setDbAttributePath(dbAttribute.getName());
        }
    }

    public String getDbAttributeName() {
        if (this.dbAttributePath == null) {
            return null;
        }
        int lastPartStart = this.dbAttributePath.lastIndexOf(46);
        String lastPart = StringUtils.substring(this.dbAttributePath, lastPartStart + 1, this.dbAttributePath.length());
        return lastPart;
    }

    public void setDbAttributeName(String dbAttributeName) {
        if (this.dbAttributePath == null || dbAttributeName == null) {
            this.dbAttributePath = dbAttributeName;
            return;
        }
        int lastPartStart = this.dbAttributePath.lastIndexOf(46);
        String newPath = lastPartStart > 0 ? StringUtils.chomp(this.dbAttributePath, ".") : "";
        this.dbAttributePath = newPath = newPath + (newPath.length() > 0 ? "." : "") + dbAttributeName;
    }

    public void setDbAttributePath(String dbAttributePath) {
        this.dbAttributePath = dbAttributePath;
    }

    public String getDbAttributePath() {
        return this.dbAttributePath;
    }

    public boolean isCompound() {
        return this.dbAttributePath != null && this.dbAttributePath.indexOf(46) >= 0;
    }

    public boolean mapsToDependentDbEntity() {
        Iterator i = this.getDbPathIterator();
        if (!i.hasNext()) {
            return false;
        }
        Object o = i.next();
        if (!i.hasNext()) {
            return false;
        }
        Object o1 = i.next();
        if (!(o1 instanceof DbAttribute)) {
            return false;
        }
        DbRelationship toDependent = (DbRelationship)o;
        return toDependent.isToDependentPK();
    }

    public void validate() throws CayenneException {
        String head = "ObjAttribute: " + this.getName() + " ";
        ObjEntity ent = (ObjEntity)this.getEntity();
        if (ent == null) {
            throw new CayenneException(head + "Parent ObjEntity not defined.");
        }
        head = head + "ObjEntity: " + ent.getName() + " ";
        if (this.getName() == null) {
            throw new CayenneException(head + "ObjAttribute's name not defined.");
        }
        if (this.getDbAttributePath() == null) {
            throw new CayenneException(head + "dbAttributePath not defined.");
        }
        try {
            Iterator i = this.getDbPathIterator();
            boolean dbAttributeFound = false;
            while (i.hasNext()) {
                Object pathPart = i.next();
                if (pathPart instanceof DbRelationship) {
                    DbRelationship r = (DbRelationship)pathPart;
                    if (!r.isToMany()) continue;
                    throw new CayenneException(head + "DbRelationship: " + r.getName() + " is to-many.");
                }
                if (!(pathPart instanceof DbAttribute)) continue;
                dbAttributeFound = true;
            }
            if (!dbAttributeFound) {
                throw new CayenneException(head + "DbAttribute not found.");
            }
        }
        catch (CayenneException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CayenneException(head + ex.getMessage(), ex);
        }
    }

    public ObjAttribute getClientAttribute() {
        ObjAttribute attribute = new ObjAttribute(this.getName());
        attribute.setType(this.getType());
        return attribute;
    }
}

