/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.event.EventManager;
import org.objectstyle.cayenne.exp.ExpressionException;
import org.objectstyle.cayenne.exp.parser.ASTDbPath;
import org.objectstyle.cayenne.map.ClientObjRelationship;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.map.DeleteRule;
import org.objectstyle.cayenne.map.Entity;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.Relationship;
import org.objectstyle.cayenne.map.event.RelationshipEvent;
import org.objectstyle.cayenne.util.Util;
import org.objectstyle.cayenne.util.XMLEncoder;

public class ObjRelationship
extends Relationship
implements EventListener {
    boolean readOnly;
    boolean dbRelationshipsRefreshNeeded = true;
    protected int deleteRule = 0;
    protected boolean usedForLocking;
    protected String dbRelationshipPath;
    protected List dbRelationships = new ArrayList();

    public ObjRelationship() {
        this(null);
    }

    public ObjRelationship(String name) {
        super(name);
    }

    public void encodeAsXML(XMLEncoder encoder) {
        String path;
        ObjEntity source = (ObjEntity)this.getSourceEntity();
        if (source == null) {
            return;
        }
        encoder.print("<obj-relationship name=\"" + this.getName());
        encoder.print("\" source=\"" + source.getName());
        ObjEntity target = (ObjEntity)this.getTargetEntity();
        if (target != null) {
            encoder.print("\" target=\"" + target.getName());
        }
        if (this.isUsedForLocking()) {
            encoder.print("\" lock=\"true");
        }
        String deleteRule = DeleteRule.deleteRuleName(this.getDeleteRule());
        if (this.getDeleteRule() != 0 && deleteRule != null) {
            encoder.print("\" deleteRule=\"" + deleteRule);
        }
        if ((path = this.getValidRelationshipPath()) != null) {
            encoder.print("\" db-relationship-path=\"" + path);
        }
        encoder.println("\"/>");
    }

    public Entity getTargetEntity() {
        String targetName = this.getTargetEntityName();
        if (targetName == null) {
            return null;
        }
        return this.getNonNullNamespace().getObjEntity(targetName);
    }

    public String getReverseRelationshipName() {
        ObjRelationship reverse = this.getReverseRelationship();
        return reverse != null ? reverse.getName() : null;
    }

    public ObjRelationship getReverseRelationship() {
        ArrayList<DbRelationship> reversed = new ArrayList<DbRelationship>();
        Iterator rit = this.getDbRelationships().iterator();
        while (rit.hasNext()) {
            DbRelationship rel = (DbRelationship)rit.next();
            DbRelationship reverse = rel.getReverseRelationship();
            if (reverse == null) {
                return null;
            }
            reversed.add(0, reverse);
        }
        Entity target = this.getTargetEntity();
        if (target == null) {
            return null;
        }
        Entity src = this.getSourceEntity();
        Iterator it = target.getRelationships().iterator();
        while (it.hasNext()) {
            ObjRelationship rel = (ObjRelationship)it.next();
            if (rel.getTargetEntity() != src) continue;
            List otherRels = rel.getDbRelationships();
            if (reversed.size() != otherRels.size()) continue;
            int len = reversed.size();
            boolean relsMatch = true;
            for (int i = 0; i < len; ++i) {
                if (otherRels.get(i) == reversed.get(i)) continue;
                relsMatch = false;
                break;
            }
            if (!relsMatch) continue;
            return rel;
        }
        return null;
    }

    public List getDbRelationships() {
        this.refreshFromPath(true);
        return Collections.unmodifiableList(this.dbRelationships);
    }

    public void addDbRelationship(DbRelationship dbRel) {
        DbRelationship lastRel;
        this.refreshFromPath(true);
        int numDbRelationships = this.dbRelationships.size();
        if (numDbRelationships > 0 && !(lastRel = (DbRelationship)this.dbRelationships.get(numDbRelationships - 1)).getTargetEntityName().equals(dbRel.getSourceEntity().getName())) {
            throw new CayenneRuntimeException("Error adding db relationship " + dbRel + " to ObjRelationship " + this + " because the source of the newly added relationship " + "is not the target of the previous relationship " + "in the chain");
        }
        EventManager.getDefaultManager().addListener(this, "dbRelationshipDidChange", RelationshipEvent.class, DbRelationship.PROPERTY_DID_CHANGE, dbRel);
        this.dbRelationships.add(dbRel);
        this.calculateReadOnlyValue();
        this.calculateToManyValue();
    }

    public void removeDbRelationship(DbRelationship dbRel) {
        this.refreshFromPath(true);
        this.dbRelationships.remove(dbRel);
        EventManager.getDefaultManager().removeListener(this, DbRelationship.PROPERTY_DID_CHANGE, dbRel);
        this.calculateReadOnlyValue();
        this.calculateToManyValue();
    }

    public void clearDbRelationships() {
        this.dbRelationshipPath = null;
        this.dbRelationshipsRefreshNeeded = false;
        this.dbRelationships.clear();
        this.readOnly = false;
        this.toMany = false;
    }

    public boolean isSourceIndependentFromTargetChange() {
        return this.isToMany() || this.isFlattened() || this.isToDependentEntity() || !this.isToPK();
    }

    public boolean isToDependentEntity() {
        return ((DbRelationship)this.getDbRelationships().get(0)).isToDependentPK();
    }

    public boolean isToPK() {
        return ((DbRelationship)this.getDbRelationships().get(0)).isToPK();
    }

    public boolean isFlattened() {
        return this.getDbRelationships().size() > 1;
    }

    public boolean isReadOnly() {
        this.refreshFromPath(true);
        return this.readOnly;
    }

    public boolean isToMany() {
        this.refreshFromPath(true);
        return super.isToMany();
    }

    public int getDeleteRule() {
        return this.deleteRule;
    }

    public void setDeleteRule(int value) {
        if (value != 2 && value != 3 && value != 1 && value != 0) {
            throw new IllegalArgumentException("Delete rule value " + value + " is not a constant from the DeleteRule class");
        }
        this.deleteRule = value;
    }

    public void dbRelationshipDidChange(RelationshipEvent event) {
        this.calculateToManyValue();
    }

    public boolean isUsedForLocking() {
        return this.usedForLocking;
    }

    public void setUsedForLocking(boolean usedForLocking) {
        this.usedForLocking = usedForLocking;
    }

    public String getDbRelationshipPath() {
        if (this.dbRelationshipsRefreshNeeded) {
            return this.dbRelationshipPath;
        }
        if (this.getDbRelationships().isEmpty()) {
            return null;
        }
        StringBuffer path = new StringBuffer();
        Iterator it = this.getDbRelationships().iterator();
        while (it.hasNext()) {
            DbRelationship next = (DbRelationship)it.next();
            path.append(next.getName());
            if (!it.hasNext()) continue;
            path.append(".");
        }
        return path.toString();
    }

    public String getReverseDbRelationshipPath() throws ExpressionException {
        List relationships = this.getDbRelationships();
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        ListIterator it = relationships.listIterator(relationships.size());
        while (it.hasPrevious()) {
            DbRelationship relationship = (DbRelationship)it.previous();
            DbRelationship reverse = relationship.getReverseRelationship();
            if (reverse == null) {
                throw new CayenneRuntimeException("No reverse relationship exist for " + relationship);
            }
            if (buffer.length() > 0) {
                buffer.append(".");
            }
            buffer.append(reverse.getName());
        }
        return buffer.toString();
    }

    public void setDbRelationshipPath(String relationshipPath) {
        if (!Util.nullSafeEquals(this.dbRelationshipPath, relationshipPath)) {
            this.dbRelationshipPath = relationshipPath;
            this.dbRelationshipsRefreshNeeded = true;
        }
    }

    String getValidRelationshipPath() {
        String path = this.getDbRelationshipPath();
        if (path == null) {
            return null;
        }
        ObjEntity entity = (ObjEntity)this.getSourceEntity();
        if (entity == null) {
            throw new CayenneRuntimeException("Can't resolve DbRelationships, null source ObjEntity");
        }
        StringBuffer validPath = new StringBuffer();
        try {
            Iterator it = entity.resolvePathComponents(new ASTDbPath(path));
            while (it.hasNext()) {
                DbRelationship relationship = (DbRelationship)it.next();
                if (validPath.length() > 0) {
                    validPath.append(".");
                }
                validPath.append(relationship.getName());
            }
        }
        catch (ExpressionException ex) {
            // empty catch block
        }
        return validPath.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void refreshFromPath(boolean stripInvalid) {
        if (!this.dbRelationshipsRefreshNeeded) {
            return;
        }
        ObjRelationship objRelationship = this;
        synchronized (objRelationship) {
            block11: {
                if (!this.dbRelationshipsRefreshNeeded) {
                    return;
                }
                EventManager eventLoop = EventManager.getDefaultManager();
                Iterator removeIt = this.dbRelationships.iterator();
                while (removeIt.hasNext()) {
                    DbRelationship relationship = (DbRelationship)removeIt.next();
                    eventLoop.removeListener(this, DbRelationship.PROPERTY_DID_CHANGE, relationship);
                    removeIt.remove();
                }
                if (this.dbRelationshipPath != null) {
                    ObjEntity entity = (ObjEntity)this.getSourceEntity();
                    if (entity == null) {
                        throw new CayenneRuntimeException("Can't resolve DbRelationships, null source ObjEntity");
                    }
                    try {
                        Iterator it = entity.resolvePathComponents(new ASTDbPath(this.dbRelationshipPath));
                        while (it.hasNext()) {
                            DbRelationship relationship = (DbRelationship)it.next();
                            eventLoop.addListener(this, "dbRelationshipDidChange", class$org$objectstyle$cayenne$map$event$RelationshipEvent == null ? ObjRelationship.class$("org.objectstyle.cayenne.map.event.RelationshipEvent") : class$org$objectstyle$cayenne$map$event$RelationshipEvent, DbRelationship.PROPERTY_DID_CHANGE, relationship);
                            this.dbRelationships.add(relationship);
                        }
                    }
                    catch (ExpressionException ex) {
                        if (stripInvalid) break block11;
                        throw ex;
                    }
                }
            }
            this.calculateToManyValue();
            this.calculateReadOnlyValue();
            this.dbRelationshipsRefreshNeeded = false;
        }
    }

    final void calculateToManyValue() {
        Iterator dbRelIterator = this.dbRelationships.iterator();
        while (dbRelIterator.hasNext()) {
            DbRelationship thisRel = (DbRelationship)dbRelIterator.next();
            if (!thisRel.isToMany()) continue;
            this.toMany = true;
            return;
        }
        this.toMany = false;
    }

    final void calculateReadOnlyValue() {
        if (this.dbRelationships.size() < 2) {
            this.readOnly = false;
            return;
        }
        if (this.dbRelationships.size() > 2) {
            this.readOnly = true;
            return;
        }
        DbRelationship firstRel = (DbRelationship)this.dbRelationships.get(0);
        DbRelationship secondRel = (DbRelationship)this.dbRelationships.get(1);
        if (!firstRel.isToMany() || secondRel.isToMany()) {
            this.readOnly = true;
            return;
        }
        DataMap map = firstRel.getTargetEntity().getDataMap();
        if (map == null) {
            throw new CayenneRuntimeException(this.getClass().getName() + " could not obtain a DataMap for the destination of " + firstRel.getName());
        }
        if (!secondRel.isToPK()) {
            this.readOnly = true;
            return;
        }
        DbRelationship firstReverseRel = firstRel.getReverseRelationship();
        if (firstReverseRel == null || !firstReverseRel.isToPK()) {
            this.readOnly = true;
            return;
        }
        this.readOnly = false;
    }

    public String toString() {
        return new ToStringBuilder(this).append("name", this.getName()).append("dbRelationshipPath", this.dbRelationshipPath).toString();
    }

    public ObjRelationship getClientRelationship() {
        ObjRelationship reverse = this.getReverseRelationship();
        String reverseName = reverse != null ? reverse.getName() : null;
        ClientObjRelationship relationship = new ClientObjRelationship(this.getName(), reverseName, this.isToMany(), this.isReadOnly());
        relationship.setTargetEntityName(this.getTargetEntityName());
        relationship.setDeleteRule(this.getDeleteRule());
        return relationship;
    }
}

