/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.opp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.opp.OPPConnection;
import org.objectstyle.cayenne.opp.OPPMessage;

public abstract class BaseConnection
implements OPPConnection {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected long messageId;

    protected BaseConnection() {
    }

    public Object sendMessage(OPPMessage message) throws CayenneRuntimeException {
        Object response;
        if (message == null) {
            throw new NullPointerException("Null message");
        }
        this.beforeSendMessage(message);
        long t0 = 0L;
        String messageLabel = "";
        long messageId = this.messageId++;
        if (this.logger.isInfoEnabled()) {
            t0 = System.currentTimeMillis();
            messageLabel = message.toString();
            this.logger.info("--- Message " + messageId + ": " + messageLabel);
        }
        try {
            response = this.doSendMessage(message);
        }
        catch (CayenneRuntimeException e) {
            if (this.logger.isInfoEnabled()) {
                long time = System.currentTimeMillis() - t0;
                this.logger.info("*** Message error for " + messageId + ": " + messageLabel + " - took " + time + " ms.");
            }
            throw e;
        }
        if (this.logger.isInfoEnabled()) {
            long time = System.currentTimeMillis() - t0;
            this.logger.info("=== Message " + messageId + ": " + messageLabel + " done - took " + time + " ms.");
        }
        return response;
    }

    public long getProcessedMessagesCount() {
        return this.messageId + 1L;
    }

    protected abstract void beforeSendMessage(OPPMessage var1) throws CayenneRuntimeException;

    protected abstract Object doSendMessage(OPPMessage var1) throws CayenneRuntimeException;
}

