/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.opp;

import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.DataChannel;
import org.objectstyle.cayenne.event.EventBridge;
import org.objectstyle.cayenne.opp.BaseConnection;
import org.objectstyle.cayenne.opp.DispatchHelper;
import org.objectstyle.cayenne.opp.OPPMessage;
import org.objectstyle.cayenne.opp.hessian.HessianUtil;
import org.objectstyle.cayenne.util.Util;

public class LocalConnection
extends BaseConnection {
    public static final int NO_SERIALIZATION = 0;
    public static final int JAVA_SERIALIZATION = 1;
    public static final int HESSIAN_SERIALIZATION = 2;
    protected DataChannel channel;
    protected int serializationPolicy;

    public LocalConnection(DataChannel handler) {
        this(handler, 0);
    }

    public LocalConnection(DataChannel handler, int serializationPolicy) {
        this.channel = handler;
        this.serializationPolicy = serializationPolicy == 1 || serializationPolicy == 2 ? serializationPolicy : 0;
    }

    public boolean isSerializingMessages() {
        return this.serializationPolicy == 1 || this.serializationPolicy == 2;
    }

    public DataChannel getChannel() {
        return this.channel;
    }

    public EventBridge getServerEventBridge() {
        return null;
    }

    protected void beforeSendMessage(OPPMessage message) {
    }

    protected Object doSendMessage(OPPMessage message) throws CayenneRuntimeException {
        try {
            OPPMessage processedMessage;
            switch (this.serializationPolicy) {
                case 2: {
                    processedMessage = (OPPMessage)HessianUtil.cloneViaHessianSerialization(message);
                    break;
                }
                case 1: {
                    processedMessage = (OPPMessage)Util.cloneViaSerialization(message);
                    break;
                }
                default: {
                    processedMessage = message;
                }
            }
            return DispatchHelper.dispatch(this.channel, processedMessage);
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error sending message", ex);
        }
    }
}

