/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.project;

import java.io.PrintWriter;
import org.objectstyle.cayenne.conf.ConfigSaver;
import org.objectstyle.cayenne.conf.ConfigSaverDelegate;
import org.objectstyle.cayenne.conf.RuntimeSaveDelegate;
import org.objectstyle.cayenne.project.ApplicationProject;
import org.objectstyle.cayenne.project.Project;
import org.objectstyle.cayenne.project.ProjectFile;

public class ApplicationProjectFile
extends ProjectFile {
    protected ConfigSaverDelegate saveDelegate;
    private String objectName = null;

    private ApplicationProjectFile() {
    }

    public ApplicationProjectFile(Project project) {
        this(project, "cayenne.xml");
    }

    public ApplicationProjectFile(Project project, String fileName) {
        super(project, fileName);
        this.objectName = fileName.substring(0, fileName.lastIndexOf(this.getLocationSuffix()));
    }

    public String getLocationSuffix() {
        return ".xml";
    }

    public Object getObject() {
        return this.getProject();
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void save(PrintWriter out) throws Exception {
        ConfigSaverDelegate localDelegate = this.saveDelegate != null ? this.saveDelegate : new RuntimeSaveDelegate(((ApplicationProject)this.projectObj).getConfiguration());
        new ConfigSaver(localDelegate).storeDomains(out);
    }

    public boolean canHandle(Object obj) {
        return obj instanceof ApplicationProject;
    }

    public ConfigSaverDelegate getSaveDelegate() {
        return this.saveDelegate;
    }

    public void setSaveDelegate(ConfigSaverDelegate saveDelegate) {
        this.saveDelegate = saveDelegate;
    }
}

