/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.project;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.objectstyle.cayenne.conf.ConfigStatus;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.map.MapLoader;
import org.objectstyle.cayenne.project.DataMapFile;
import org.objectstyle.cayenne.project.NamedObjectFactory;
import org.objectstyle.cayenne.project.Project;
import org.objectstyle.cayenne.project.ProjectException;
import org.objectstyle.cayenne.project.ProjectFile;
import org.xml.sax.InputSource;

public class DataMapProject
extends Project {
    private static Logger logObj = Logger.getLogger(DataMapProject.class);
    protected DataMap map;

    public DataMapProject(File projectFile) {
        super(projectFile);
    }

    public void upgrade() throws ProjectException {
        throw new ProjectException("'DataMapProject' does not support upgrades.");
    }

    public void checkForUpgrades() {
    }

    protected void postInitialize(File projectFile) {
        if (projectFile != null) {
            try {
                FileInputStream in = new FileInputStream(projectFile.getCanonicalFile());
                this.map = new MapLoader().loadDataMap(new InputSource(in));
                String fileName = this.resolveSymbolicName(projectFile);
                logObj.error("resolving: " + projectFile + " to " + fileName);
                String mapName = fileName != null && fileName.endsWith(".map.xml") ? fileName.substring(0, fileName.length() - ".map.xml".length()) : "UntitledMap";
                this.map.setName(mapName);
            }
            catch (Exception dme) {
                throw new ProjectException("Error creating " + this.getClass().getName(), dme);
            }
        } else {
            this.map = (DataMap)NamedObjectFactory.createObject(DataMap.class, null);
        }
        super.postInitialize(projectFile);
    }

    public List getChildren() {
        ArrayList<DataMap> entities = new ArrayList<DataMap>();
        entities.add(this.map);
        return entities;
    }

    public ProjectFile projectFileForObject(Object obj) {
        if (obj == this) {
            return new DataMapFile((Project)this, this.map);
        }
        return null;
    }

    public ConfigStatus getLoadStatus() {
        return new ConfigStatus();
    }
}

