/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.project.validator;

import java.util.Iterator;
import org.objectstyle.cayenne.map.DbJoin;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.project.ProjectPath;
import org.objectstyle.cayenne.project.validator.MappingNamesHelper;
import org.objectstyle.cayenne.project.validator.TreeNodeValidator;
import org.objectstyle.cayenne.project.validator.Validator;
import org.objectstyle.cayenne.util.Util;

public class DbRelationshipValidator
extends TreeNodeValidator {
    public void validateObject(ProjectPath path, Validator validator) {
        DbRelationship rel = (DbRelationship)path.getObject();
        if (rel.getTargetEntity() == null) {
            validator.registerWarning("DbRelationship " + this.dbRelationshipIdentifier(rel) + " has no target entity.", path);
        } else if (rel.getJoins().size() == 0) {
            validator.registerWarning("DbRelationship " + this.dbRelationshipIdentifier(rel) + " has no joins.", path);
        } else {
            Iterator joins = rel.getJoins().iterator();
            while (joins.hasNext()) {
                DbJoin join = (DbJoin)joins.next();
                if (join.getSource() == null && join.getTarget() == null) {
                    validator.registerWarning("DbRelationship " + this.dbRelationshipIdentifier(rel) + " join has no source and target attributes selected.", path);
                    continue;
                }
                if (join.getSource() == null) {
                    validator.registerWarning("DbRelationship " + this.dbRelationshipIdentifier(rel) + " join has no source attribute selected.", path);
                    continue;
                }
                if (join.getTarget() != null) continue;
                validator.registerWarning("DbRelationship " + this.dbRelationshipIdentifier(rel) + " join has no target attribute selected.", path);
            }
            if (rel.getReverseRelationship() == null) {
                validator.registerWarning("Missing reverse DbRelationship " + this.dbRelationshipIdentifier(rel) + " (currently required by Cayenne).", path);
            }
        }
        if (Util.isEmptyString(rel.getName())) {
            validator.registerError("Unnamed DbRelationship.", path);
        } else if (rel.getSourceEntity().getAttribute(rel.getName()) != null) {
            validator.registerWarning("DbRelationship " + this.dbRelationshipIdentifier(rel) + " has the same name as one of DbAttributes", path);
        } else {
            MappingNamesHelper helper = MappingNamesHelper.getInstance();
            String invalidChars = helper.invalidCharsInDbPathComponent(rel.getName());
            if (invalidChars != null) {
                validator.registerWarning("DbRelationship " + this.dbRelationshipIdentifier(rel) + " name contains invalid characters: " + invalidChars, path);
            }
        }
    }

    public String dbRelationshipIdentifier(DbRelationship rel) {
        if (null == rel.getSourceEntity()) {
            return "<[null source entity]." + rel.getName() + ">";
        }
        return "<" + rel.getSourceEntity().getName() + "." + rel.getName() + ">";
    }
}

