/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.project.validator;

import java.util.Iterator;
import org.objectstyle.cayenne.access.DataDomain;
import org.objectstyle.cayenne.project.Project;
import org.objectstyle.cayenne.project.ProjectPath;
import org.objectstyle.cayenne.project.validator.TreeNodeValidator;
import org.objectstyle.cayenne.project.validator.Validator;
import org.objectstyle.cayenne.util.Util;

public class DomainValidator
extends TreeNodeValidator {
    public void validateObject(ProjectPath path, Validator validator) {
        DataDomain domain = (DataDomain)path.getObject();
        String name = domain.getName();
        if (Util.isEmptyString(name)) {
            validator.registerError("Unnamed DataDomain.", path);
            return;
        }
        Project project = (Project)path.getObjectParent();
        if (project == null) {
            return;
        }
        Iterator it = project.getChildren().iterator();
        while (it.hasNext()) {
            DataDomain dom = (DataDomain)it.next();
            if (dom == domain || !name.equals(dom.getName())) continue;
            validator.registerError("Duplicate DataDomain name: " + name + ".", path);
            return;
        }
    }
}

