/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.query.BatchQuery;

public class InsertBatchQuery
extends BatchQuery {
    protected List objectIds;
    protected List objectSnapshots;
    protected List dbAttributes;

    public InsertBatchQuery(DbEntity entity, int batchCapacity) {
        super(entity);
        this.objectSnapshots = new ArrayList(batchCapacity);
        this.objectIds = new ArrayList(batchCapacity);
        this.dbAttributes = new ArrayList(this.getDbEntity().getAttributes());
    }

    public Object getValue(int dbAttributeIndex) {
        DbAttribute attribute = (DbAttribute)this.dbAttributes.get(dbAttributeIndex);
        Map currentSnapshot = (Map)this.objectSnapshots.get(this.batchIndex);
        return this.getValue(currentSnapshot, attribute);
    }

    public void add(Map snapshot) {
        this.add(snapshot, null);
    }

    public void add(Map snapshot, ObjectId id) {
        this.objectSnapshots.add(snapshot);
        this.objectIds.add(id);
    }

    public int size() {
        return this.objectSnapshots.size();
    }

    public List getDbAttributes() {
        return this.dbAttributes;
    }

    public ObjectId getObjectId() {
        return (ObjectId)this.objectIds.get(this.batchIndex);
    }
}

