/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.Persistent;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.query.IndirectQuery;
import org.objectstyle.cayenne.query.ParameterizedQuery;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.QueryMetadata;
import org.objectstyle.cayenne.query.QueryMetadataWrapper;
import org.objectstyle.cayenne.util.Util;

public class NamedQuery
extends IndirectQuery {
    protected Map parameters;
    protected boolean forceNoCache;
    protected QueryMetadata metadata;
    transient int hashCode;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NamedQuery(String name) {
        this(name, null);
    }

    public NamedQuery(String name, Map parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    public NamedQuery(String name, String[] keys, Object[] values) {
        this.name = name;
        this.parameters = Util.toMap(keys, values);
    }

    public QueryMetadata getMetaData(EntityResolver resolver) {
        if (this.metadata != null) {
            return this.metadata;
        }
        QueryMetadata info = super.getMetaData(resolver);
        if (!this.forceNoCache) {
            return info;
        }
        String policy = info.getCachePolicy();
        String override = null;
        if ("localcache".equals(policy)) {
            override = "localcache_refresh";
        } else if ("sharedcache".equals(policy)) {
            override = "sharedcache_refresh";
        } else {
            return info;
        }
        QueryMetadataWrapper wrapper = new QueryMetadataWrapper(info);
        wrapper.override("cayenne.GenericSelectQuery.cachePolicy", override);
        return wrapper;
    }

    protected Query createReplacementQuery(EntityResolver resolver) {
        Query query = this.resolveQuery(resolver);
        if (query instanceof ParameterizedQuery) {
            Map parameters;
            Map map = parameters = this.parameters != null ? this.parameters : Collections.EMPTY_MAP;
            if (!parameters.isEmpty()) {
                HashMap substitutes = null;
                Iterator it = parameters.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Object value = entry.getValue();
                    ObjectId substitute = null;
                    if (value instanceof Persistent && !(value instanceof DataObject)) {
                        substitute = ((Persistent)value).getObjectId();
                    }
                    if (substitute == null) continue;
                    if (substitutes == null) {
                        substitutes = new HashMap(parameters);
                    }
                    substitutes.put(entry.getKey(), substitute);
                }
                if (substitutes != null) {
                    parameters = substitutes;
                }
            }
            query = ((ParameterizedQuery)query).createQuery(parameters);
        }
        return query;
    }

    protected Query resolveQuery(EntityResolver resolver) {
        Query query = resolver.lookupQuery(this.getName());
        if (query == null) {
            throw new CayenneRuntimeException("Can't find named query for name '" + this.getName() + "'");
        }
        if (query == this) {
            throw new CayenneRuntimeException("Named query resolves to self: '" + this.getName() + "'");
        }
        return query;
    }

    public String toString() {
        return StringUtils.substringAfterLast(this.getClass().getName(), ".") + ":" + this.getName();
    }

    public QueryMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(QueryMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NamedQuery)) {
            return false;
        }
        NamedQuery query = (NamedQuery)object;
        if (!Util.nullSafeEquals(this.name, query.getName())) {
            return false;
        }
        if (query.parameters == null && this.parameters == null) {
            return true;
        }
        if (query.parameters == null || this.parameters == null) {
            return false;
        }
        if (query.parameters.size() != this.parameters.size()) {
            return false;
        }
        EqualsBuilder builder = new EqualsBuilder();
        Iterator entries = this.parameters.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Object entryKey = entry.getKey();
            Object entryValue = entry.getValue();
            if (entryValue == null) {
                if (query.parameters.get(entryKey) == null && query.parameters.containsKey(entryKey)) continue;
                return false;
            }
            builder.append(entryValue, query.parameters.get(entryKey));
            if (builder.isEquals()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeBuilder builder = new HashCodeBuilder(13, 17);
            if (this.name != null) {
                builder.append(this.name.hashCode());
            }
            if (this.parameters != null) {
                Object[] keys = this.parameters.keySet().toArray();
                Arrays.sort(keys);
                for (int i = 0; i < keys.length; ++i) {
                    builder.append(keys[i]).append(this.parameters.get(keys[i]));
                }
            }
            this.hashCode = builder.toHashCode();
            if (!$assertionsDisabled && this.hashCode == 0) {
                throw new AssertionError((Object)"Generated zero hashCode");
            }
        }
        return this.hashCode;
    }

    public boolean isForceNoCache() {
        return this.forceNoCache;
    }

    public void setForceNoCache(boolean forcingNoCache) {
        this.forceNoCache = forcingNoCache;
    }

    static {
        $assertionsDisabled = !NamedQuery.class.desiredAssertionStatus();
    }
}

