/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.query;

import org.apache.commons.lang.StringUtils;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.exp.ExpressionFactory;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.query.DefaultQueryMetadata;
import org.objectstyle.cayenne.query.IndirectQuery;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.QueryMetadata;
import org.objectstyle.cayenne.query.SelectQuery;
import org.objectstyle.cayenne.util.Util;

public class ObjectIdQuery
extends IndirectQuery {
    public static final int CACHE = 1;
    public static final int CACHE_REFRESH = 2;
    public static final int CACHE_NOREFRESH = 3;
    protected ObjectId objectId;
    protected int cachePolicy;
    protected boolean fetchingDataRows;

    private ObjectIdQuery() {
        this.cachePolicy = 2;
    }

    public ObjectIdQuery(ObjectId objectID) {
        this(objectID, false, 2);
    }

    public ObjectIdQuery(ObjectId objectId, boolean fetchingDataRows, int cachePolicy) {
        if (objectId == null) {
            throw new NullPointerException("Null objectID");
        }
        this.objectId = objectId;
        this.cachePolicy = cachePolicy;
        this.fetchingDataRows = fetchingDataRows;
    }

    public QueryMetadata getMetaData(final EntityResolver resolver) {
        return new DefaultQueryMetadata(){

            public ObjEntity getObjEntity() {
                return resolver.lookupObjEntity(ObjectIdQuery.this.objectId.getEntityName());
            }

            public boolean isFetchingDataRows() {
                return ObjectIdQuery.this.fetchingDataRows;
            }
        };
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    protected Query createReplacementQuery(EntityResolver resolver) {
        if (this.objectId == null) {
            throw new CayenneRuntimeException("Can't resolve query - objectId is null.");
        }
        if (this.objectId.isTemporary() && !this.objectId.isReplacementIdAttached()) {
            throw new CayenneRuntimeException("Can't build a query for temporary id: " + this.objectId);
        }
        SelectQuery query = new SelectQuery(this.objectId.getEntityName(), ExpressionFactory.matchAllDbExp(this.objectId.getIdSnapshot(), 3));
        query.setRefreshingObjects(true);
        query.setFetchingDataRows(this.fetchingDataRows);
        return query;
    }

    public Object getRoot() {
        return this.objectId.getEntityName();
    }

    public int getCachePolicy() {
        return this.cachePolicy;
    }

    public boolean isFetchMandatory() {
        return this.cachePolicy == 2;
    }

    public boolean isFetchAllowed() {
        return this.cachePolicy != 3;
    }

    public boolean isFetchingDataRows() {
        return this.fetchingDataRows;
    }

    public String toString() {
        return StringUtils.substringAfterLast(this.getClass().getName(), ".") + ":" + this.objectId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectIdQuery)) {
            return false;
        }
        ObjectIdQuery query = (ObjectIdQuery)object;
        return Util.nullSafeEquals(this.objectId, query.getObjectId());
    }

    public int hashCode() {
        return this.objectId != null ? this.objectId.hashCode() : 11;
    }
}

