/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.tools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.tools.ant.Task;
import org.objectstyle.cayenne.util.CayenneMapEntry;

public class NamePatternMatcher {
    protected Task parentTask;
    protected Pattern[] itemIncludeFilters;
    protected Pattern[] itemExcludeFilters;

    public NamePatternMatcher(Task parentTask, String includePattern, String excludePattern) {
        this.parentTask = parentTask;
        this.itemIncludeFilters = this.createPatterns(includePattern);
        this.itemExcludeFilters = this.createPatterns(excludePattern);
    }

    public Pattern[] createPatterns(String patternString) {
        String[] patternStrings = this.tokenizePattern(patternString);
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(patternStrings.length);
        for (int i = 0; i < patternStrings.length; ++i) {
            try {
                patterns.add(Pattern.compile(patternStrings[i]));
                continue;
            }
            catch (PatternSyntaxException e) {
                if (this.parentTask == null) continue;
                this.parentTask.log("Ignoring invalid pattern [" + patternStrings[i] + "], reason: " + e.getMessage(), 1);
            }
        }
        return patterns.toArray(new Pattern[patterns.size()]);
    }

    public String[] tokenizePattern(String pattern) {
        if (pattern != null && pattern.length() > 0) {
            StringTokenizer toks = new StringTokenizer(pattern, ",");
            int len = toks.countTokens();
            if (len == 0) {
                return new String[0];
            }
            ArrayList<String> patterns = new ArrayList<String>(len);
            for (int i = 0; i < len; ++i) {
                String nextPattern = toks.nextToken();
                StringBuffer buffer = new StringBuffer();
                buffer.append("^");
                for (int j = 0; j < nextPattern.length(); ++j) {
                    char nextChar = nextPattern.charAt(j);
                    if (nextChar == '*' || nextChar == '?') {
                        buffer.append('.');
                    }
                    buffer.append(nextChar);
                }
                buffer.append("$");
                patterns.add(buffer.toString());
            }
            return patterns.toArray(new String[patterns.size()]);
        }
        return new String[0];
    }

    protected List filter(List items) {
        if (items == null || items.isEmpty()) {
            return items;
        }
        if (this.itemIncludeFilters.length == 0 && this.itemExcludeFilters.length == 0) {
            return items;
        }
        Iterator it = items.iterator();
        while (it.hasNext()) {
            CayenneMapEntry entity = (CayenneMapEntry)it.next();
            if (!this.passedIncludeFilter(entity)) {
                it.remove();
                continue;
            }
            if (this.passedExcludeFilter(entity)) continue;
            it.remove();
        }
        return items;
    }

    protected boolean passedIncludeFilter(CayenneMapEntry item) {
        if (this.itemIncludeFilters.length == 0) {
            return true;
        }
        String itemName = item.getName();
        for (int i = 0; i < this.itemIncludeFilters.length; ++i) {
            if (!this.itemIncludeFilters[i].matcher(itemName).find()) continue;
            return true;
        }
        return false;
    }

    protected boolean passedExcludeFilter(CayenneMapEntry item) {
        if (this.itemExcludeFilters.length == 0) {
            return true;
        }
        String itemName = item.getName();
        for (int i = 0; i < this.itemExcludeFilters.length; ++i) {
            if (!this.itemExcludeFilters[i].matcher(itemName).find()) continue;
            return false;
        }
        return true;
    }

    public static String replaceWildcardInStringWithString(String wildcard, String pattern, String replacement) {
        if (null == pattern || null == wildcard) {
            return pattern;
        }
        StringBuffer buffer = new StringBuffer();
        int lastPos = 0;
        int wildCardPos = pattern.indexOf(wildcard);
        while (-1 != wildCardPos) {
            if (lastPos != wildCardPos) {
                buffer.append(pattern.substring(lastPos, wildCardPos));
            }
            buffer.append(replacement);
            wildCardPos = pattern.indexOf(wildcard, lastPos += wildCardPos + wildcard.length());
        }
        if (lastPos < pattern.length()) {
            buffer.append(pattern.substring(lastPos));
        }
        return buffer.toString();
    }
}

