/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.objectstyle.cayenne.CayenneRuntimeException;

public class MemoryClob
implements Clob {
    volatile String data;

    public MemoryClob(String data) {
        if (data == null) {
            throw new CayenneRuntimeException("Null data");
        }
        this.data = data;
    }

    public long length() throws SQLException {
        String ldata = this.data;
        return ldata.length();
    }

    public String getSubString(long pos, int length) throws SQLException {
        String ldata = this.data;
        int dlen = ldata.length();
        if (--pos < 0L || pos > (long)dlen) {
            new CayenneRuntimeException("Invalid position: " + (pos + 1L));
        }
        if (length < 0 || (long)length > (long)dlen - pos) {
            throw new CayenneRuntimeException("Invalid length: " + length);
        }
        if (pos == 0L && length == dlen) {
            return ldata;
        }
        return ldata.substring((int)pos, (int)pos + length);
    }

    public Reader getCharacterStream() throws SQLException {
        String ldata = this.data;
        return new StringReader(ldata);
    }

    public InputStream getAsciiStream() throws SQLException {
        String ldata = this.data;
        return new AsciiStringInputStream(ldata);
    }

    public long position(String searchstr, long start) throws SQLException {
        int pos;
        if (searchstr == null || start > Integer.MAX_VALUE) {
            return -1L;
        }
        String ldata = this.data;
        return (pos = ldata.indexOf(searchstr, (int)(--start))) < 0 ? -1L : (long)(pos + 1);
    }

    public long position(Clob searchstr, long start) throws SQLException {
        long sslen;
        if (searchstr == null) {
            return -1L;
        }
        String ldata = this.data;
        long dlen = ldata.length();
        if (start > dlen - (sslen = searchstr.length())) {
            return -1L;
        }
        String s = searchstr instanceof MemoryClob ? ((MemoryClob)searchstr).data : searchstr.getSubString(1L, (int)sslen);
        int pos = ldata.indexOf(s, (int)start);
        return pos < 0 ? -1L : (long)(pos + 1);
    }

    public int setString(long pos, String str) throws SQLException {
        throw new CayenneRuntimeException("Not supported");
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        throw new CayenneRuntimeException("Not supported");
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw new CayenneRuntimeException("Not supported");
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        throw new CayenneRuntimeException("Not supported");
    }

    public void truncate(long len) throws SQLException {
        long chars = len >> 1;
        String ldata = this.data;
        long dlen = ldata.length();
        if (chars != dlen) {
            if (len < 0L || chars > dlen) {
                throw new CayenneRuntimeException("Invalid length: " + len);
            }
            this.data = new String(ldata.substring(0, (int)chars));
        }
    }

    class AsciiStringInputStream
    extends InputStream {
        protected int strOffset = 0;
        protected int charOffset = 0;
        protected int available;
        protected String str;

        public AsciiStringInputStream(String s) {
            this.str = s;
            this.available = s.length() * 2;
        }

        public int doRead() throws IOException {
            if (this.available == 0) {
                return -1;
            }
            --this.available;
            char c = this.str.charAt(this.strOffset);
            if (this.charOffset == 0) {
                this.charOffset = 1;
                return (c & 0xFF00) >> 8;
            }
            this.charOffset = 0;
            ++this.strOffset;
            return c & 0xFF;
        }

        public int read() throws IOException {
            this.doRead();
            return this.doRead();
        }

        public int available() throws IOException {
            return this.available / 2;
        }
    }
}

